/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;

public class JaxAtsObject
extends NamedIdBase {
    protected String guid;
    protected boolean active;
    private String description;
    @JsonIgnore
    protected AtsApi atsApi;
    @JsonIgnore
    private ArtifactToken artifact;
    private List<WorkType> workTypes = new ArrayList<WorkType>();
    private List<String> tags = new ArrayList<String>();

    public JaxAtsObject() {
        this(Id.SENTINEL, "");
    }

    public JaxAtsObject(Long id, String name) {
        super(id, name);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean matches(JaxAtsObject ... identities) {
        JaxAtsObject[] jaxAtsObjectArray = identities;
        int n = identities.length;
        int n2 = 0;
        while (n2 < n) {
            JaxAtsObject identity = jaxAtsObjectArray[n2];
            if (this.equals((Object)identity)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public AtsApi getAtsApi() {
        return this.atsApi;
    }

    public void setAtsApi(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    @JsonIgnore
    public ArtifactToken getStoreObject() {
        if (this.artifact == null && this.atsApi != null) {
            this.artifact = this.atsApi.getQueryService().getArtifact(this.getId());
        }
        return this.artifact;
    }

    public void setStoreObject(ArtifactToken artifact) {
        this.artifact = artifact;
    }

    public ArtifactToken getArtifactToken() {
        if (this.artifact != null) {
            return this.artifact;
        }
        return ArtifactToken.valueOf((long)this.id, (String)this.getName(), (BranchToken)CoreBranches.COMMON);
    }

    public Collection<WorkType> getWorkTypes() {
        return this.workTypes;
    }

    public void setWorkTypes(List<WorkType> workTypes) {
        this.workTypes = workTypes;
    }

    public boolean isWorkType(WorkType workType) {
        return this.getWorkTypes().contains((Object)workType);
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean hasTag(String tag) {
        return this.getTags().contains(tag);
    }
}

