/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.define.api.DefineBranchEndpointApi;
import org.eclipse.osee.define.rest.operations.ValidateBranchOperation;
import org.eclipse.osee.define.rest.operations.ValidateProcFuncCalls;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;

@Path(value="branch")
public final class DefineBranchEndpointImpl
implements DefineBranchEndpointApi {
    private final JdbcClient jdbcClient;
    private final OrcsApi orcsApi;

    public DefineBranchEndpointImpl(JdbcClient jdbcClient, OrcsApi orcsApi) {
        this.jdbcClient = jdbcClient;
        this.orcsApi = orcsApi;
    }

    @GET
    @Path(value="{branch}/validate/arttype/{artType}/all")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData validateAll(@PathParam(value="branch") BranchId branch, @PathParam(value="artType") ArtifactTypeToken artType) {
        ValidateBranchOperation op = new ValidateBranchOperation(this.jdbcClient, branch, this.orcsApi);
        return op.runAll(artType);
    }

    @GET
    @Path(value="{branch}/validate/arttype/{artType}/dupparent")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData getChildrenWithMultipleParents(@PathParam(value="branch") BranchId branch, @PathParam(value="artType") ArtifactTypeToken artType) {
        ValidateBranchOperation op = new ValidateBranchOperation(this.jdbcClient, branch, this.orcsApi);
        return op.getChildrenWithMultipleParents(artType);
    }

    @GET
    @Path(value="{branch}/validate/arttype/{artType}/orphan")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData getOrphans(@PathParam(value="branch") BranchId branch, @PathParam(value="artType") ArtifactTypeToken artType) {
        ValidateBranchOperation op = new ValidateBranchOperation(this.jdbcClient, branch, this.orcsApi);
        return op.getOrphans(artType);
    }

    @GET
    @Path(value="{branch}/validate/proc")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData getProcFuncTrace(@PathParam(value="branch") BranchId branch) {
        ValidateProcFuncCalls op = new ValidateProcFuncCalls(this.jdbcClient, branch, this.orcsApi);
        return op.get();
    }

    @GET
    @Path(value="conv")
    @Produces(value={"text/html"})
    @Consumes(value={"application/json"})
    public String convertSrs() {
        ValidateProcFuncCalls op = new ValidateProcFuncCalls(this.jdbcClient, null, this.orcsApi);
        op.searchAndReplace();
        return AHTML.simplePage((String)"Done");
    }
}

