/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.resolvers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.define.api.importing.RoughArtifact;
import org.eclipse.osee.define.api.importing.RoughAttributeSet;
import org.eclipse.osee.define.rest.importing.resolvers.IRoughArtifactTranslator;
import org.eclipse.osee.define.rest.importing.resolvers.NewArtifactImportResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class AttributeBasedArtifactResolver
extends NewArtifactImportResolver {
    private final Collection<AttributeTypeToken> nonChangingAttributes;
    private final boolean createNewIfNotExist;

    public AttributeBasedArtifactResolver(TransactionBuilder transaction, IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType, Collection<AttributeTypeToken> nonChangingAttributes, boolean createNewIfNotExist, boolean deleteUnmatchedArtifacts) {
        super(transaction, translator, primaryArtifactType, secondaryArtifactType);
        this.nonChangingAttributes = nonChangingAttributes;
        this.createNewIfNotExist = createNewIfNotExist;
    }

    private boolean attributeValuesMatch(RoughArtifact roughArtifact, ArtifactReadable artifact) {
        RoughAttributeSet roughAttributeSet = roughArtifact.getAttributes();
        for (AttributeTypeToken attributeType : this.nonChangingAttributes) {
            List attributeValues = artifact.getAttributeValues(attributeType);
            Collection roughAttributes = roughAttributeSet.getAttributeValueList(attributeType, new ArrayList());
            if (attributeValues.size() != roughAttributes.size()) continue;
            for (String attributeValue : attributeValues) {
                Iterator iter = roughAttributes.iterator();
                String normalizedAttributeValue = this.normalizeAttributeValue(attributeValue);
                while (iter.hasNext()) {
                    String otherAttribute = (String)iter.next();
                    if (!normalizedAttributeValue.equals(this.normalizeAttributeValue(otherAttribute))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private String normalizeAttributeValue(String value) {
        return value.trim().replaceAll("\\.$", "").toLowerCase();
    }

    @Override
    public ArtifactId resolve(RoughArtifact roughArtifact, BranchId branch, ArtifactId realParentId, ArtifactId rootId) {
        ArtifactReadable realArtifact = null;
        RoughArtifact roughParent = roughArtifact.getRoughParent();
        if (roughParent != null) {
            ArtifactReadable root = roughArtifact.getOrcsApi().getQueryFactory().fromBranch(branch).andId(rootId).getArtifact();
            List descendants = root.getDescendants();
            LinkedList<ArtifactReadable> candidates = new LinkedList<ArtifactReadable>();
            roughArtifact.getResults().logf("Resolved using: %s", new Object[]{!descendants.isEmpty() ? "root node." : "realParent descendants."});
            ArtifactReadable realParent = roughArtifact.getOrcsApi().getQueryFactory().fromBranch(branch).andId(realParentId).getArtifact();
            for (ArtifactReadable artifact : !descendants.isEmpty() ? descendants : realParent.getDescendants()) {
                if (!this.attributeValuesMatch(roughArtifact, artifact)) continue;
                candidates.add(artifact);
            }
            if (candidates.size() == 1) {
                realArtifact = (ArtifactReadable)candidates.iterator().next();
                this.getTranslator().translate(this.transaction, roughArtifact, (ArtifactId)realArtifact);
            } else {
                roughArtifact.getResults().logf("Found %s candidates during reuse import for \"%s\"", new Object[]{candidates.size(), roughArtifact.getName()});
                if (this.createNewIfNotExist) {
                    return super.resolve(roughArtifact, branch, null, (ArtifactId)root);
                }
            }
        }
        return realArtifact;
    }
}

