/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.osee.define.api.publishing.PublishingOptions;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class PublishingOptionsFactory<K extends Enum<K>> {
    private final Map<K, PublishingOptions> map;

    private PublishingOptionsFactory(Map<K, PublishingOptions> publishingOptionsMap) {
        this.map = publishingOptionsMap;
    }

    private PublishingOptions create(K key) {
        PublishingOptions parentPublishingOptions = this.map.get(key);
        PublishingOptions publishingOptions = Objects.nonNull(parentPublishingOptions) ? (PublishingOptions)parentPublishingOptions.clone() : new PublishingOptions();
        return publishingOptions;
    }

    public PublishingOptions create(K key, BranchId branchId) {
        PublishingOptions publishingOptions = this.create(key);
        if (Objects.isNull(branchId)) {
            return publishingOptions;
        }
        if (branchId.isInvalid()) {
            publishingOptions.branch = BranchId.SENTINEL;
            publishingOptions.view = ArtifactId.SENTINEL;
            return publishingOptions;
        }
        publishingOptions.branch = branchId;
        ArtifactId viewArtifactId = branchId.getViewId();
        if (Objects.isNull(viewArtifactId)) {
            return publishingOptions;
        }
        if (viewArtifactId.isInvalid()) {
            publishingOptions.view = ArtifactId.SENTINEL;
        }
        publishingOptions.view = viewArtifactId;
        return publishingOptions;
    }

    public PublishingOptions create(K key, BranchId branchId, ArtifactId viewArtifactId) {
        assert (!Objects.nonNull(branchId) || !Objects.nonNull(branchId.getViewId()) || !Objects.nonNull(viewArtifactId) || ArtifactId.SENTINEL.equals(branchId.getViewId()) || ArtifactId.SENTINEL.equals(viewArtifactId) || !branchId.getViewId().equals(viewArtifactId)) : new Message().title((CharSequence)"PublishingOptionsFactory::create, The view identifier in the branch identifier is not consistent with the specified view identifier.").indentInc().segment((CharSequence)"Branch Identifier", (Object)branchId.getIdString()).segment((CharSequence)"View Identifier In Branch Identifier", (Object)branchId.getViewId().getIdString()).segment((CharSequence)"View Identifer From Parameter", (Object)viewArtifactId.getIdString()).toString();
        PublishingOptions publishingOptions = this.create(key);
        if (Objects.isNull(branchId)) {
            return publishingOptions;
        }
        if (branchId.isInvalid()) {
            publishingOptions.branch = BranchId.SENTINEL;
            publishingOptions.view = ArtifactId.SENTINEL;
            return publishingOptions;
        }
        publishingOptions.branch = branchId;
        if (Objects.isNull(viewArtifactId)) {
            return publishingOptions;
        }
        if (viewArtifactId.isInvalid()) {
            publishingOptions.view = ArtifactId.SENTINEL;
        }
        publishingOptions.view = viewArtifactId;
        return publishingOptions;
    }

    public static <K extends Enum<K>> PublishingOptionsFactory<K> ofEntries(Class<K> enumerationKeyClass, Function<K, PublishingOptions> enumToPublishingOptionsFunction) {
        EnumMap map = new EnumMap(enumerationKeyClass);
        EnumSet.allOf(enumerationKeyClass).forEach(key -> {
            PublishingOptions publishingOptions = map.put((Object)key, (PublishingOptions)enumToPublishingOptionsFunction.apply(key));
        });
        PublishingOptionsFactory<K> publishingOptionsFactory = new PublishingOptionsFactory<K>(map);
        return publishingOptionsFactory;
    }
}

