/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.mim.types.ConnectionViewData;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.PLGenericDBObject;
import org.eclipse.osee.mim.types.TransportType;

public class ConnectionView
extends PLGenericDBObject {
    @JsonIgnore
    private String Name;
    private String source = "";
    private String target = "";
    private String label = "";
    private ConnectionViewData data;

    public ConnectionView(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public ConnectionView(InterfaceConnection connection) {
        this(connection.getId(), connection.getName(), connection.getDescription(), connection.getTransportType());
        if (connection.getNodes().size() > 0) {
            this.setSource(connection.getNodes().get(0).getIdString());
        }
        if (connection.getNodes().size() > 1) {
            this.setTarget(connection.getNodes().get(1).getIdString());
        }
        this.setApplicability(connection.getApplicability());
    }

    public ConnectionView(ArtifactReadable art) {
        this();
        this.setId(art.getId());
        this.setName(art.getName());
        this.setData(new ConnectionViewData(art));
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public ConnectionView(Long id, String name, String description, TransportType transportType) {
        this(id, name);
        this.setLabel(name);
        this.setData(new ConnectionViewData(id, name));
        this.setDescription(description);
        this.setTransportType(transportType);
    }

    public ConnectionView(Long id, String name) {
        super(id, name);
    }

    public ConnectionView() {
    }

    @JsonIgnore
    public String getDescription() {
        return this.data.getDescription();
    }

    public void setDescription(String description) {
        this.data.setDescription(description);
    }

    @JsonIgnore
    public String getName() {
        return super.getName();
    }

    public void setName(String name) {
        super.setName(name);
        this.setLabel(name);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ConnectionViewData getData() {
        return this.data;
    }

    public void setData(ConnectionViewData data) {
        this.data = data;
    }

    @JsonIgnore
    public TransportType getTransportType() {
        return this.data.getTransportType();
    }

    @JsonIgnore
    public void setTransportType(TransportType type) {
        this.data.setTransportType(type);
    }

    @JsonIgnore
    public boolean getIsDashed() {
        return this.data.isDashed();
    }

    @JsonIgnore
    public void setIsDashed(boolean isDashed) {
        this.data.setDashed(isDashed);
    }

    @JsonIgnore
    public ApplicabilityToken getApplicability() {
        return this.data.getApplicability();
    }

    public void setApplicability(ApplicabilityToken applicabilityToken) {
        this.data.setApplicability(applicabilityToken);
    }
}

