/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util.toggles;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.util.toggles.Toggles;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class TogglesFactory {
    private static Map<String, String> implementationClasses = Map.of("org.eclipse.osee.framework.skynet.core", "org.eclipse.osee.framework.skynet.core.httpRequests.TogglesClientImpl", "org.eclipse.osee.define", "org.eclipse.osee.define.operations.toggles.TogglesOperationsImpl");
    private static Toggles defaultToggles = new Toggles(){

        @Override
        public Boolean apply(String name) {
            return false;
        }
    };
    private static Toggles togglesImpl = null;

    private static List<Bundle> getBundles(Set<String> bundleNames) {
        try {
            return Arrays.stream(FrameworkUtil.getBundle(TogglesFactory.class).getBundleContext().getBundles()).filter(bundle -> bundleNames.contains(bundle.getSymbolicName())).collect(Collectors.toList());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private static Class<?> loadClass(Bundle bundle, String className) throws ClassNotFoundException {
        return ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader().loadClass(className);
    }

    public static synchronized Toggles getTogglesImpl() {
        if (Objects.nonNull(togglesImpl)) {
            return togglesImpl;
        }
        try {
            List<Bundle> bundles = TogglesFactory.getBundles(implementationClasses.keySet());
            if (bundles.size() != 1) {
                return defaultToggles;
            }
            Bundle bundle = bundles.get(0);
            String implementationClass = implementationClasses.get(bundle.getSymbolicName());
            Class<?> aClass = TogglesFactory.loadClass(bundle, implementationClass);
            togglesImpl = (Toggles)aClass.getMethod("create", new Class[0]).invoke(null, new Object[0]);
            return togglesImpl;
        }
        catch (Exception exception) {
            return defaultToggles;
        }
    }
}

