/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class OseeInf {
    public static final String ROOT_DIR = "OSEE-INF/";

    public static InputStream getResourceAsStream(String path, Class<?> classFromBundle) {
        return OsgiUtil.getResourceAsStream(classFromBundle, ROOT_DIR + path);
    }

    public static InputStream getResourceAsStream(String filePath, Object obj) throws OseeCoreException {
        ClassLoader classLoader = obj.getClass().getClassLoader();
        InputStream resourceAsStream = classLoader.getResourceAsStream(filePath);
        if (resourceAsStream == null) {
            resourceAsStream = classLoader.getResourceAsStream(ROOT_DIR + filePath);
        }
        if (resourceAsStream != null) {
            return resourceAsStream;
        }
        throw new OseeCoreException("Resource not found at %s nor %s", new Object[]{filePath, ROOT_DIR + filePath});
    }

    public static String getResourceContents(String path, Class<?> classFromBundle) {
        return OsgiUtil.getResourceAsString(classFromBundle, ROOT_DIR + path);
    }

    public static File getResourceAsFile(String path, Class<?> clazz) {
        try {
            URL url = OseeInf.getResourceAsUrl(path, clazz);
            String uri = new URI(url.toString().replace(" ", "%20")).getPath();
            return new File(uri);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static URL getResourceAsUrl(String path, Class<?> clazz) {
        return OsgiUtil.getResourceAsUrl(clazz, ROOT_DIR + path);
    }
}

