/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.metrics;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.rest.metrics.DevProgressItemId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;

public final class DevProgressMetrics
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private String programVersion;
    private final String targetVersion;
    private final Date startDate;
    private final Date endDate;
    private final boolean allTime;
    private ExcelXmlWriter writer;
    Pattern UI_NAME = Pattern.compile("\\{.*\\}");
    Pattern UI_DELETED = Pattern.compile("^.*\\(Deleted\\)$");
    private final DevProgressItemId[] actionColumns = new DevProgressItemId[]{DevProgressItemId.ACT, DevProgressItemId.ActionName, DevProgressItemId.Program, DevProgressItemId.Build, DevProgressItemId.Date, DevProgressItemId.Created, DevProgressItemId.WorkType, DevProgressItemId.TW, DevProgressItemId.State, DevProgressItemId.Analyze, DevProgressItemId.Authorize, DevProgressItemId.Implement, DevProgressItemId.Complete, DevProgressItemId.Cancelled, DevProgressItemId.TotalCount, DevProgressItemId.CompletedCount, DevProgressItemId.CancelledCount, DevProgressItemId.TotalAddModCount, DevProgressItemId.CompletedAddModCount, DevProgressItemId.CancelledAddModCount, DevProgressItemId.TotalDeletedCount, DevProgressItemId.CompletedDeletedCount, DevProgressItemId.CancelledDeletedCount};

    public DevProgressMetrics(OrcsApi orcsApi, AtsApi atsApi, String targetVersion, Date startDate, Date endDate, boolean allTime) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.programVersion = null;
        this.targetVersion = targetVersion;
        this.startDate = startDate;
        this.endDate = endDate;
        this.allTime = allTime;
    }

    public void write(OutputStream output) {
        try {
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            this.writeReport();
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            try {
                this.writer.endWorkbook();
            }
            catch (IOException ex1) {
                throw new WebApplicationException((Throwable)ex1);
            }
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeReport() throws IOException {
        List<IAtsAction> actionableItems = this.getDatedWorkflows();
        if (!actionableItems.isEmpty()) {
            this.writer.startSheet("Non-Periodic Data", this.actionColumns.length);
            this.fillActionableData(actionableItems, this.actionColumns.length);
        }
    }

    private List<IAtsAction> getDatedWorkflows() {
        ArtifactToken versionId = this.atsApi.getQueryService().getArtifactFromTypeAndAttribute(AtsArtifactTypes.Version, (AttributeTypeToken)CoreAttributeTypes.Name, this.targetVersion, (BranchId)this.atsApi.getAtsBranch());
        Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)versionId);
        Collection workflowArts = this.atsApi.getVersionService().getTargetedForTeamWorkflows((IAtsVersion)version);
        ArrayList<IAtsAction> actionableItems = new ArrayList<IAtsAction>();
        for (IAtsTeamWorkflow workflow : workflowArts) {
            try {
                if (actionableItems.contains(workflow.getParentAction()) || !workflow.isWorkType(WorkType.Requirements) && !workflow.isWorkType(WorkType.Code) && !workflow.isWorkType(WorkType.Test)) continue;
                if (this.allTime) {
                    actionableItems.add(workflow.getParentAction());
                    continue;
                }
                if (!workflow.getCreatedDate().before(this.endDate) || workflow.isCompleted() && workflow.getCompletedDate() != null && workflow.getCompletedDate().before(this.startDate) || workflow.isCancelled() && workflow.getCancelledDate() != null && workflow.getCancelledDate().before(this.startDate)) continue;
                actionableItems.add(workflow.getParentAction());
            }
            catch (Exception exception) {}
        }
        this.programVersion = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition).getName();
        return actionableItems;
    }

    private void fillActionableData(List<IAtsAction> actionableItems, int numColumns) throws IOException {
        Object[] buffer = new Object[numColumns];
        int i = 0;
        while (i < numColumns) {
            buffer[i] = this.actionColumns[i].getDisplayName();
            ++i;
        }
        this.writer.writeRow(buffer);
        for (IAtsAction actionItem : actionableItems) {
            buffer[0] = actionItem.getAtsId();
            buffer[1] = actionItem.getName();
            buffer[2] = this.programVersion;
            buffer[3] = this.targetVersion;
            buffer[4] = this.endDate;
            Date createdDate = new Date();
            for (IAtsTeamWorkflow teamWorkflow : actionItem.getTeamWorkflows()) {
                if (!teamWorkflow.getCreatedDate().before(createdDate)) continue;
                createdDate = teamWorkflow.getCreatedDate();
            }
            buffer[5] = createdDate;
            this.fillTeamWfData(buffer, this.endDate, actionItem);
        }
        this.writer.endSheet();
    }

    /*
     * Exception decompiling
     */
    private void fillTeamWfData(Object[] buffer, Date rowDate, IAtsAction actionItem) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[16] lbl133 : CaseStatement: default:\u000a, @NONE, blocks:[16] lbl133 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getStateAtDate(IAtsWorkItem teamWorkflow, Date iterationDate) {
        if (this.allTime) {
            return teamWorkflow.getCurrentStateName();
        }
        String stateName = teamWorkflow.getStateMgr().getCurrentStateNameFast();
        Date stateStartDate = new GregorianCalendar(1916, 7, 15).getTime();
        try {
            Date newStateStartDate = teamWorkflow.getStateMgr().getStateStartedData(stateName).getDate();
            if (newStateStartDate.after(iterationDate)) {
                for (String visitedState : teamWorkflow.getStateMgr().getVisitedStateNames()) {
                    newStateStartDate = teamWorkflow.getStateMgr().getStateStartedData(visitedState).getDate();
                    if (!newStateStartDate.before(iterationDate) || !newStateStartDate.after(stateStartDate)) continue;
                    stateName = visitedState;
                    stateStartDate = newStateStartDate;
                }
            }
        }
        catch (Exception exception) {}
        return stateName;
    }

    private Date getStateStartedDate(IAtsWorkItem teamWorkflow, Date iterationDate, String stateName) {
        try {
            IAtsLogItem stateStartedData = teamWorkflow.getStateMgr().getStateStartedData(stateName);
            if (stateStartedData.getDate().before(iterationDate)) {
                return stateStartedData.getDate();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private Collection<IAtsTask> getTaskList(IAtsTeamWorkflow teamWorkflow, Date iterationDate) {
        ArrayList<IAtsTask> tasks = new ArrayList<IAtsTask>();
        ArrayList<String> taskUINames = new ArrayList<String>();
        for (IAtsTask task : this.atsApi.getTaskService().getTasks(teamWorkflow)) {
            Matcher m = this.UI_NAME.matcher(task.getName());
            if (!m.find()) continue;
            String taskUIName = m.group();
            if (!task.getCreatedDate().before(iterationDate) || taskUINames.contains(taskUIName)) continue;
            taskUINames.add(taskUIName);
            tasks.add(task);
        }
        return tasks;
    }

    private double[] getDeletedTaskCount(IAtsTeamWorkflow teamWorkflow, Date iterationDate, Collection<IAtsTask> tasks) {
        double[] deletedCounts = new double[3];
        double deletedCount = 0.0;
        double deletedCompleteCount = 0.0;
        double deletedCancelledCount = 0.0;
        for (IAtsTask task : tasks) {
            Matcher m;
            if (task.getCreatedDate().after(iterationDate) || !(m = this.UI_DELETED.matcher(task.getName())).find()) continue;
            try {
                deletedCount += 1.0;
                StateDefinition state = this.stateNameToDefinition((IAtsWorkItem)task, iterationDate);
                if (task.isCompleted() && (this.allTime || task.getCompletedDate().before(iterationDate))) {
                    deletedCompleteCount += 1.0;
                    continue;
                }
                if (task.isCancelled() && (this.allTime || task.getCancelledDate().before(iterationDate))) {
                    deletedCancelledCount += 1.0;
                    continue;
                }
                if (state.getRecommendedPercentComplete() == null || state.getRecommendedPercentComplete() <= 0) continue;
                deletedCompleteCount += (double)(state.getRecommendedPercentComplete() / 100);
            }
            catch (Exception exception) {}
        }
        deletedCounts[0] = deletedCount;
        deletedCounts[1] = deletedCompleteCount;
        deletedCounts[2] = deletedCancelledCount;
        return deletedCounts;
    }

    private double getTaskCompleted(IAtsTeamWorkflow teamWorkflow, Date iterationDate, Collection<IAtsTask> tasks) {
        double completedTasks = 0.0;
        for (IAtsTask task : tasks) {
            try {
                StateDefinition state = this.stateNameToDefinition((IAtsWorkItem)task, iterationDate);
                if (state == null) {
                    throw new OseeCoreException("In DevProgressMetrics.getTaskCompleted, the local variable \"state\" is null which is dereferenced", new Object[0]);
                }
                if (task.isCompleted() && task.getCompletedDate().before(iterationDate) || state.getName().equals("No_Change")) {
                    completedTasks += 1.0;
                    continue;
                }
                if (state.getRecommendedPercentComplete() == null || state.getRecommendedPercentComplete() <= 0 || state.getName().equals("Cancelled")) continue;
                completedTasks += (double)state.getRecommendedPercentComplete().intValue() / 100.0;
            }
            catch (Exception exception) {}
        }
        return completedTasks;
    }

    private StateDefinition stateNameToDefinition(IAtsWorkItem item, Date iterationDate) {
        if (this.allTime) {
            return item.getStateDefinition();
        }
        String stateAtDate = this.getStateAtDate(item, iterationDate);
        if (stateAtDate.equals(item.getCurrentStateName())) {
            return item.getStateDefinition();
        }
        for (StateDefinition state : item.getWorkDefinition().getStates()) {
            if (!state.getName().equals(stateAtDate)) continue;
            return state;
        }
        return null;
    }

    private int getTaskCancelled(IAtsTeamWorkflow teamWorkflow, Date iterationDate, Collection<IAtsTask> tasks) {
        ArrayList<IAtsTask> iterationTasks = new ArrayList<IAtsTask>();
        for (IAtsTask task : tasks) {
            try {
                if (!task.isCancelled() || !task.getCancelledDate().before(iterationDate)) continue;
                iterationTasks.add(task);
            }
            catch (Exception exception) {}
        }
        return iterationTasks.size();
    }
}

