/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.journal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.journal.JournalData;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class JournalOperations {
    private final AtsApi atsApi;
    private IAtsWorkItem workItem;
    private final JournalData journalData;
    private final String atsId;
    private final String CONFIG_KEY = "JournalUrl";

    public JournalOperations(JournalData journalData, String atsId, AtsApi atsApi) {
        this.journalData = journalData;
        this.atsId = atsId;
        this.atsApi = atsApi;
    }

    public JournalData validate() {
        this.workItem = this.atsApi.getWorkItemService().getWorkItemByAtsId(this.atsId);
        if (this.workItem == null) {
            this.journalData.getResults().errorf("Invalid ATS Id [%s]", new Object[]{this.atsId});
        }
        return this.journalData;
    }

    public JournalData addJournal() {
        this.validate();
        if (this.journalData.getResults().isErrors()) {
            return this.journalData;
        }
        try {
            String journalStr = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.Journal, (Object)"");
            String timeName = String.format("====== %s on %s =================", this.journalData.getUser().getName(), new Date());
            String msg = this.journalData.getAddMsg();
            if (Strings.isValid((String)msg)) {
                msg = msg.replaceFirst("^[ \n]+", "");
                msg = msg.replaceFirst("[ \n]+$", "");
                journalStr = String.format("%s\n%s\n\n%s", timeName, msg, journalStr);
                IAtsChangeSet changes = this.atsApi.createChangeSet("Post to Journal", this.journalData.getUser());
                changes.setSoleAttributeValue(this.workItem, (AttributeTypeToken)AtsAttributeTypes.Journal, journalStr);
                Collection subscribed = this.atsApi.getAttributeResolver().getAttributeValues((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.JournalSubscriber);
                if (!subscribed.contains(this.journalData.getUser())) {
                    changes.addAttribute((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.JournalSubscriber, (Object)this.journalData.getUser().getArtifactId());
                }
                TransactionToken transaction = changes.execute();
                this.workItem = this.atsApi.getWorkItemService().getWorkItem(this.workItem.getId());
                this.journalData.setCurrentMsg((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.Journal, (Object)""));
                this.atsApi.getWorkItemService().getJournalSubscribed(this.workItem, this.journalData);
                this.journalData.setTransaction(TransactionId.valueOf((Long)transaction.getId()));
                this.sendNotifications();
            }
        }
        catch (Exception ex) {
            this.journalData.getResults().errorf("Exception adding journal %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return this.journalData;
    }

    public JournalData sendNotifications() {
        try {
            Collection subscribedUsers = this.atsApi.getNotificationService().getJournalSubscribedUsers(this.workItem);
            subscribedUsers.remove(this.journalData.getUser());
            if (subscribedUsers.isEmpty()) {
                return this.journalData;
            }
            String fromEmail = this.atsApi.getConfigValue("NoReplyEmail");
            if (EmailUtil.isEmailValid((String)fromEmail)) {
                for (AtsUser user : subscribedUsers) {
                    this.atsApi.getNotificationService().sendNotifications(fromEmail, Collections.singleton(user.getEmail()), this.getSubject(), this.getBody(user));
                }
            }
        }
        catch (Exception ex) {
            this.journalData.getResults().errorf("Exception sending Journal notification %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return this.journalData;
    }

    private String getBody(AtsUser user) {
        String journalUrl = this.atsApi.getConfigValue("JournalUrl");
        if (Strings.isValid((String)journalUrl)) {
            journalUrl = journalUrl.replaceFirst("ATSID", this.workItem.getAtsId());
            journalUrl = journalUrl.replaceFirst("USERARTID", user.getIdString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><b>Do not respond or forward this email!</b><br/><br/>");
        if (Strings.isValid((String)journalUrl)) {
            sb.append("<a href=\"");
            sb.append(journalUrl);
            sb.append("\">Select to Respond</a>");
            sb.append("<br/>");
        }
        sb.append("<br/>");
        sb.append("<pre>");
        JournalData jData = this.atsApi.getWorkItemService().getJournalData(this.workItem, new JournalData());
        String comments = jData.getResults().isErrors() ? jData.getResults().toString() : jData.getCurrentMsg();
        sb.append(comments);
        sb.append("</pre>");
        sb.append("</body></html>");
        return sb.toString();
    }

    private String getSubject() {
        return String.format("OSEE ATS Journal for \"%s\"", this.workItem.toStringWithAtsId());
    }
}

