/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.agile.operations;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class EndpointOperations {
    private final AtsApi atsApi;

    public EndpointOperations(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public ArtifactToken filterOutActiveIfSet(Boolean active, ArtifactToken art) {
        Boolean storedActive = (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)AtsAttributeTypes.Active, null);
        if (storedActive != null && !storedActive.equals(active)) {
            return null;
        }
        return art;
    }

    public Boolean getActiveQueryParamOrNull(UriInfo uriInfo) {
        MultivaluedMap qp;
        String activeStr;
        Boolean active = null;
        if (uriInfo != null && Strings.isValid((String)(activeStr = (String)(qp = uriInfo.getQueryParameters(true)).getFirst((Object)"active")))) {
            active = "true".equals(activeStr);
        }
        return active;
    }

    public List<JaxAtsObject> getActiveArtifactTypeTokens(ArtifactTypeToken artifactType, UriInfo uriInfo) throws Exception {
        Boolean active = this.getActiveQueryParamOrNull(uriInfo);
        ArrayList<JaxAtsObject> teams = new ArrayList<JaxAtsObject>();
        for (ArtifactToken art : this.atsApi.getQueryService().getArtifacts(artifactType)) {
            if (active != null && this.filterOutActiveIfSet(active, art) == null) continue;
            JaxAtsObject token = new JaxAtsObject();
            token.setName(art.getName());
            token.setId(art.getId());
            teams.add(token);
        }
        return teams;
    }
}

