/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.SqlTable;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.QueryType;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.QuerySqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class QuerySqlContextFactoryImpl
implements QuerySqlContextFactory {
    private final Log logger;
    private final SqlHandlerFactory handlerFactory;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final SqlTable table;
    private final String idColumn;
    private final QuerySqlContext.ObjectQueryType type;

    public QuerySqlContextFactoryImpl(Log logger, SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlHandlerFactory handlerFactory, SqlTable table, String idColumn, QuerySqlContext.ObjectQueryType type) {
        this.logger = logger;
        this.joinFactory = joinFactory;
        this.jdbcClient = jdbcClient;
        this.handlerFactory = handlerFactory;
        this.table = table;
        this.idColumn = idColumn;
        this.type = type;
    }

    @Override
    public QuerySqlContext createQueryContext(OrcsSession session, QueryData queryData, QueryType queryType) {
        QuerySqlContext context = new QuerySqlContext(session, queryData.getOptions(), this.type);
        queryData.setQueryType(queryType);
        QuerySqlWriter writer = new QuerySqlWriter(this.logger, this.joinFactory, this.jdbcClient, context, queryData, this.table, this.idColumn);
        writer.build(this.handlerFactory.createHandlers(queryData));
        return context;
    }
}

