/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.processor;

import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.db.internal.loader.data.RelationObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.processor.LoadProcessor;

public class RelationLoadProcessor2
extends LoadProcessor<RelationData, RelationObjectFactory> {
    private final Log logger;
    private final OrcsTokenService tokenService;

    public RelationLoadProcessor2(Log logger, RelationObjectFactory factory, OrcsTokenService tokenService) {
        super(factory);
        this.logger = logger;
        this.tokenService = tokenService;
    }

    @Override
    protected RelationData createData(Object conditions, RelationObjectFactory factory, JdbcStatement chStmt, Options options) {
        RelationData toReturn = null;
        BranchId branch = BranchId.create((Long)chStmt.getLong("branch_id"), (ArtifactId)OptionsUtil.getFromBranchView((Options)options));
        ArtifactId aArtId = ArtifactId.valueOf((Long)chStmt.getLong("a_art_id"));
        ArtifactId bArtId = ArtifactId.valueOf((Long)chStmt.getLong("b_art_id"));
        RelationTypeToken relationType = this.tokenService.getRelationTypeOrCreate(Long.valueOf(chStmt.getLong("rel_type")));
        GammaId gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
        ApplicabilityId applicId = ApplicabilityId.valueOf((Long)chStmt.getLong("app_id"));
        int rel_order = chStmt.getInt("rel_order");
        boolean historical = OptionsUtil.isHistorical((Options)options);
        CreateConditions condition = this.asConditions(conditions);
        if (!condition.isSame(branch, aArtId, bArtId, relationType, rel_order)) {
            condition.saveConditions(branch, aArtId, bArtId, relationType, gammaId, rel_order);
            TransactionId txId = TransactionId.valueOf((Long)chStmt.getLong("transaction_id"));
            VersionData version = factory.createVersion(branch, txId, gammaId, historical);
            if (historical) {
                version.setStripeId(TransactionId.valueOf((Long)chStmt.getLong("stripe_transaction_id")));
            }
            ModificationType modType = ModificationType.valueOf((long)chStmt.getInt("mod_type"));
            ArtifactId relArtId = ArtifactId.valueOf((Long)chStmt.getLong("rel_art_id"));
            toReturn = factory.createRelationData(version, relationType, modType, aArtId, bArtId, relArtId, rel_order, applicId);
        } else if (!historical) {
            this.logger.warn("multiple relation versions for branch[%s] rel_type [%s] a_artId[%s] b_artId[%s] previousGammaId[%s] currentGammaId[%s]", new Object[]{branch, relationType, aArtId, bArtId, condition.previousGammaId, gammaId});
        }
        return toReturn;
    }

    @Override
    protected Object createPreConditions(Options options) {
        return new CreateConditions();
    }

    private CreateConditions asConditions(Object conditions) {
        return (CreateConditions)conditions;
    }

    private static final class CreateConditions {
        BranchId previousBranchId = BranchId.SENTINEL;
        ArtifactId previousArtIdA = ArtifactId.SENTINEL;
        ArtifactId previousArtIdB = ArtifactId.SENTINEL;
        RelationTypeToken previousTypeId = RelationTypeToken.SENTINEL;
        GammaId previousGammaId = GammaId.SENTINEL;
        int previousRelOrder = 0;

        private CreateConditions() {
        }

        boolean isSame(BranchId branch, ArtifactId aArtId, ArtifactId bArtId, RelationTypeToken typeId, int relOrder) {
            return this.previousBranchId.equals(branch) && this.previousArtIdA.equals(aArtId) && this.previousArtIdB.equals(bArtId) && this.previousTypeId.equals(typeId) && this.previousRelOrder == relOrder;
        }

        void saveConditions(BranchId branch, ArtifactId aArtId, ArtifactId bArtId, RelationTypeToken typeId, GammaId gammaId, int relOrder) {
            this.previousBranchId = branch;
            this.previousArtIdA = aArtId;
            this.previousArtIdB = bArtId;
            this.previousTypeId = typeId;
            this.previousGammaId = gammaId;
            this.previousRelOrder = relOrder;
        }
    }
}

