/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap.internal.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;

public final class LdapEntry {
    public static final String LDAP_ENTRY__DISTINGUISHED_NAME_KEY = "dn";
    private final Map<String, Attribute> attributes;

    public LdapEntry(Map<String, Attribute> attributes) {
        this.attributes = attributes;
    }

    public Set<String> keySet() {
        return this.attributes.keySet();
    }

    public String get(String key) throws NamingException {
        String toReturn = null;
        Attribute attribute = this.attributes.get(key);
        if (attribute != null && attribute.size() > 0) {
            toReturn = String.valueOf(attribute.get(0));
        }
        return toReturn;
    }

    public String getDistinguishedName() throws NamingException {
        return this.get(LDAP_ENTRY__DISTINGUISHED_NAME_KEY);
    }

    public Map<String, String> asMap() throws NamingException {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        for (String key : this.keySet()) {
            toReturn.put(key, this.get(key));
        }
        return toReturn;
    }

    public String toString() {
        String toReturn = null;
        try {
            toReturn = this.getDistinguishedName();
        }
        catch (Exception exception) {
            toReturn = this.keySet().toString();
        }
        return toReturn;
    }
}

