/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.sql.DataSource;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.JdbcPoolConfig;
import org.eclipse.osee.jdbc.internal.JdbcConnectionFactoryManager;
import org.eclipse.osee.jdbc.internal.JdbcConnectionInfo;
import org.eclipse.osee.jdbc.internal.PooledDataSourceFetcher;

public class PoolFactory {
    private final PoolingDriverRef poolingDriver = new PoolingDriverRef();
    private final JdbcConnectionFactoryManager manager;
    private final JdbcPoolConfig poolConfiguration;

    public PoolFactory(JdbcConnectionFactoryManager manager, JdbcPoolConfig poolConfiguration) {
        this.manager = manager;
        this.poolConfiguration = poolConfiguration;
    }

    public void disposePools(Iterable<String> keys) {
        PoolingDriver driver = (PoolingDriver)this.poolingDriver.get();
        for (String key : keys) {
            try {
                driver.closePool(key);
            }
            catch (SQLException sQLException) {}
        }
        this.poolingDriver.invalidate();
    }

    public Map<String, String> getPoolStats() {
        LinkedHashMap<String, String> stats = new LinkedHashMap<String, String>();
        PoolingDriver driver = (PoolingDriver)this.poolingDriver.get();
        stats.put("db.pool.driver", this.poolConfiguration.getPoolConnectionDriver());
        String poolVersion = String.format("%s.%s", driver.getMajorVersion(), driver.getMinorVersion());
        stats.put("db.pool.version", poolVersion);
        String[] names = driver.getPoolNames();
        int count = 0;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                try {
                    ObjectPool pool = driver.getConnectionPool(name);
                    stats.put(String.format("db.pool.%s.id", count), name);
                    stats.put(String.format("db.pool.%s.active", count), String.valueOf(pool.getNumActive()));
                    stats.put(String.format("db.pool.%s.idle", count), String.valueOf(pool.getNumIdle()));
                }
                catch (SQLException sQLException) {
                    ++count;
                }
            }
            finally {
                ++count;
            }
        }
        return stats;
    }

    public Callable<DataSource> createDataSourceFetcher(JdbcConnectionInfo dbInfo) {
        return new PooledDataSourceFetcher(this.manager, this.poolingDriver, this.poolConfiguration, dbInfo);
    }

    private final class PoolingDriverRef
    extends LazyObject<PoolingDriver> {
        private PoolingDriverRef() {
        }

        protected final FutureTask<PoolingDriver> createLoaderTask() {
            Callable<PoolingDriver> callable = new Callable<PoolingDriver>(){

                @Override
                public PoolingDriver call() throws Exception {
                    PoolingDriver driver;
                    String connectionPoolDriver = ((PoolingDriverRef)PoolingDriverRef.this).PoolFactory.this.poolConfiguration.getPoolConnectionDriver();
                    String connectionPoolId = ((PoolingDriverRef)PoolingDriverRef.this).PoolFactory.this.poolConfiguration.getPoolConnectionId();
                    try {
                        Class.forName(connectionPoolDriver);
                    }
                    catch (Exception ex) {
                        throw JdbcException.newJdbcException(ex, "Error loading connection pool driver [%s]", connectionPoolDriver);
                    }
                    try {
                        driver = (PoolingDriver)DriverManager.getDriver(connectionPoolId);
                    }
                    catch (SQLException ex) {
                        throw JdbcException.newJdbcException(ex, "Error finding connection pool driver with id [%s]", connectionPoolId);
                    }
                    return driver;
                }
            };
            return new FutureTask<PoolingDriver>(callable);
        }
    }
}

