/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.applications;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.OAuthUtil;
import org.eclipse.osee.logger.Log;

@Path(value="/")
public class OseeRootResource {
    @Context
    private UriInfo uriInfo;
    @Context
    private ContainerRequestContext context;
    private final Log logger;

    public OseeRootResource(Log logger) {
        this.logger = logger;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getRoot() {
        String basePath;
        String forwardedServer = OAuthUtil.getForwarderServer();
        if (this.logger != null) {
            this.logger.trace("Forwarded Server [%s]", new Object[]{forwardedServer});
        }
        URI location = this.uriInfo.getRequestUri();
        if (this.logger != null) {
            this.logger.trace("URI Location [%s]", new Object[]{location.toString()});
        }
        if (Strings.isValid((String)forwardedServer)) {
            String[] server = forwardedServer.split(",");
            basePath = server[0];
        } else {
            basePath = location.toString();
        }
        if (this.logger != null) {
            this.logger.trace("Base Path [%s]", new Object[]{basePath});
        }
        String scheme = location.getScheme();
        URI finalUri = UriBuilder.fromPath((String)location.toString()).scheme(scheme).path("/osee/ui/index.html").fragment(location.getRawFragment()).buildFromEncoded(new Object[0]);
        if (this.logger != null) {
            this.logger.trace("Final Uri [%s]", new Object[]{finalUri});
        }
        return Response.seeOther((URI)finalUri).build();
    }
}

