/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.submodule;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.RepositoryBuilderFactory;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;

public class SubmoduleWalk
implements AutoCloseable {
    private final Repository repository;
    private final TreeWalk walk;
    private StoredConfig repoConfig;
    private AbstractTreeIterator rootTree;
    private Config modulesConfig;
    private String path;
    private Map<String, String> pathToName;
    private RepositoryBuilderFactory factory;

    public static SubmoduleWalk forIndex(Repository repository) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        try {
            DirCache index = repository.readDirCache();
            generator.setTree(new DirCacheIterator(index));
        }
        catch (IOException e) {
            generator.close();
            throw e;
        }
        return generator;
    }

    public static SubmoduleWalk forPath(Repository repository, AnyObjectId treeId, String path) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        try {
            generator.setTree(treeId);
            PathFilter filter = PathFilter.create(path);
            generator.setFilter(filter);
            generator.setRootTree(treeId);
            while (generator.next()) {
                if (!filter.isDone(generator.walk)) continue;
                return generator;
            }
        }
        catch (IOException e) {
            generator.close();
            throw e;
        }
        generator.close();
        return null;
    }

    public static SubmoduleWalk forPath(Repository repository, AbstractTreeIterator iterator, String path) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        try {
            generator.setTree(iterator);
            PathFilter filter = PathFilter.create(path);
            generator.setFilter(filter);
            generator.setRootTree(iterator);
            while (generator.next()) {
                if (!filter.isDone(generator.walk)) continue;
                return generator;
            }
        }
        catch (IOException e) {
            generator.close();
            throw e;
        }
        generator.close();
        return null;
    }

    public static File getSubmoduleDirectory(Repository parent, String path) {
        return new File(parent.getWorkTree(), path);
    }

    public static Repository getSubmoduleRepository(Repository parent, String path) throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(parent.getWorkTree(), path, parent.getFS());
    }

    public static Repository getSubmoduleRepository(File parent, String path) throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(parent, path, FS.DETECTED);
    }

    public static Repository getSubmoduleRepository(File parent, String path, FS fs) throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(parent, path, fs, new RepositoryBuilder());
    }

    public static Repository getSubmoduleRepository(File parent, String path, FS fs, BaseRepositoryBuilder<?, ? extends Repository> builder) throws IOException {
        File subWorkTree = new File(parent, path);
        if (!subWorkTree.isDirectory()) {
            return null;
        }
        try {
            return ((BaseRepositoryBuilder)((BaseRepositoryBuilder)((BaseRepositoryBuilder)builder.setMustExist(true)).setFS(fs)).setWorkTree(subWorkTree)).build();
        }
        catch (RepositoryNotFoundException e) {
            return null;
        }
    }

    public static String getSubmoduleRemoteUrl(Repository parent, String url) throws IOException {
        String remoteUrl;
        if (!url.startsWith("./") && !url.startsWith("../")) {
            return url;
        }
        String remoteName = null;
        Ref ref = parent.exactRef("HEAD");
        if (ref != null) {
            if (ref.isSymbolic()) {
                ref = ref.getLeaf();
            }
            remoteName = parent.getConfig().getString("branch", Repository.shortenRefName(ref.getName()), "remote");
        }
        if (remoteName == null) {
            remoteName = "origin";
        }
        if ((remoteUrl = parent.getConfig().getString("remote", remoteName, "url")) == null) {
            remoteUrl = parent.getWorkTree().getAbsolutePath();
            if ('\\' == File.separatorChar) {
                remoteUrl = remoteUrl.replace('\\', '/');
            }
        }
        if (remoteUrl.charAt(remoteUrl.length() - 1) == '/') {
            remoteUrl = remoteUrl.substring(0, remoteUrl.length() - 1);
        }
        int separator = 47;
        String submoduleUrl = url;
        while (submoduleUrl.length() > 0) {
            if (submoduleUrl.startsWith("./")) {
                submoduleUrl = submoduleUrl.substring(2);
                continue;
            }
            if (!submoduleUrl.startsWith("../")) break;
            int lastSeparator = remoteUrl.lastIndexOf(47);
            if (lastSeparator < 1) {
                lastSeparator = remoteUrl.lastIndexOf(58);
                separator = 58;
            }
            if (lastSeparator < 1) {
                throw new IOException(MessageFormat.format(JGitText.get().submoduleParentRemoteUrlInvalid, remoteUrl));
            }
            remoteUrl = remoteUrl.substring(0, lastSeparator);
            submoduleUrl = submoduleUrl.substring(3);
        }
        return String.valueOf(remoteUrl) + (char)separator + submoduleUrl;
    }

    public SubmoduleWalk(Repository repository) throws IOException {
        this.repository = repository;
        this.repoConfig = repository.getConfig();
        this.walk = new TreeWalk(repository);
        this.walk.setRecursive(true);
    }

    public SubmoduleWalk setModulesConfig(Config config) {
        this.modulesConfig = config;
        this.loadPathNames();
        return this;
    }

    public SubmoduleWalk setRootTree(AbstractTreeIterator tree) {
        this.rootTree = tree;
        this.modulesConfig = null;
        this.pathToName = null;
        return this;
    }

    public SubmoduleWalk setRootTree(AnyObjectId id) throws IOException {
        CanonicalTreeParser p = new CanonicalTreeParser();
        p.reset(this.walk.getObjectReader(), id);
        this.rootTree = p;
        this.modulesConfig = null;
        this.pathToName = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubmoduleWalk loadModulesConfig() throws IOException, ConfigInvalidException {
        if (this.rootTree == null) {
            File modulesFile = new File(this.repository.getWorkTree(), ".gitmodules");
            FileBasedConfig config = new FileBasedConfig(modulesFile, this.repository.getFS());
            config.load();
            this.modulesConfig = config;
            this.loadPathNames();
            return this;
        }
        Throwable throwable = null;
        Object var2_5 = null;
        try (TreeWalk configWalk = new TreeWalk(this.repository);){
            configWalk.addTree(this.rootTree);
            int idx = 0;
            while (!this.rootTree.first()) {
                this.rootTree.back(1);
                ++idx;
            }
            try {
                configWalk.setRecursive(false);
                PathFilter filter = PathFilter.create(".gitmodules");
                configWalk.setFilter(filter);
                while (configWalk.next()) {
                    if (!filter.isDone(configWalk)) continue;
                    this.modulesConfig = new BlobBasedConfig(null, this.repository, configWalk.getObjectId(0));
                    this.loadPathNames();
                    SubmoduleWalk submoduleWalk = this;
                    return submoduleWalk;
                }
                this.modulesConfig = new Config();
                this.pathToName = null;
                return this;
            }
            finally {
                if (idx > 0) {
                    this.rootTree.next(idx);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void loadPathNames() {
        this.pathToName = null;
        if (this.modulesConfig != null) {
            HashMap<String, String> pathNames = new HashMap<String, String>();
            for (String name : this.modulesConfig.getSubsections("submodule")) {
                pathNames.put(this.modulesConfig.getString("submodule", name, "path"), name);
            }
            this.pathToName = pathNames;
        }
    }

    public static boolean containsGitModulesFile(Repository repository) throws IOException {
        if (repository.isBare()) {
            return false;
        }
        File modulesFile = new File(repository.getWorkTree(), ".gitmodules");
        return modulesFile.exists();
    }

    private void lazyLoadModulesConfig() throws IOException, ConfigInvalidException {
        if (this.modulesConfig == null) {
            this.loadModulesConfig();
        }
    }

    private String getModuleName(String modulePath) {
        String name = this.pathToName != null ? this.pathToName.get(modulePath) : null;
        return name != null ? name : modulePath;
    }

    public SubmoduleWalk setFilter(TreeFilter filter) {
        this.walk.setFilter(filter);
        return this;
    }

    public SubmoduleWalk setTree(AbstractTreeIterator iterator) throws CorruptObjectException {
        this.walk.addTree(iterator);
        return this;
    }

    public SubmoduleWalk setTree(AnyObjectId treeId) throws IOException {
        this.walk.addTree(treeId);
        return this;
    }

    public SubmoduleWalk reset() {
        this.repoConfig = this.repository.getConfig();
        this.modulesConfig = null;
        this.pathToName = null;
        this.walk.reset();
        return this;
    }

    public File getDirectory() {
        return SubmoduleWalk.getSubmoduleDirectory(this.repository, this.path);
    }

    public boolean next() throws IOException {
        while (this.walk.next()) {
            if (FileMode.GITLINK != this.walk.getFileMode(0)) continue;
            this.path = this.walk.getPathString();
            return true;
        }
        this.path = null;
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public void setBuilderFactory(RepositoryBuilderFactory factory) {
        this.factory = factory;
    }

    private BaseRepositoryBuilder<?, ? extends Repository> getBuilder() {
        return this.factory != null ? (BaseRepositoryBuilder)this.factory.get() : new RepositoryBuilder();
    }

    public String getModuleName() {
        return this.getModuleName(this.path);
    }

    public ObjectId getObjectId() {
        return this.walk.getObjectId(0);
    }

    public String getModulesPath() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "path");
    }

    public String getConfigUrl() throws IOException, ConfigInvalidException {
        return this.repoConfig.getString("submodule", this.getModuleName(), "url");
    }

    public String getModulesUrl() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "url");
    }

    public String getConfigUpdate() throws IOException, ConfigInvalidException {
        return this.repoConfig.getString("submodule", this.getModuleName(), "update");
    }

    public String getModulesUpdate() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "update");
    }

    public IgnoreSubmoduleMode getModulesIgnore() throws IOException, ConfigInvalidException {
        IgnoreSubmoduleMode mode = (IgnoreSubmoduleMode)this.repoConfig.getEnum(IgnoreSubmoduleMode.values(), "submodule", this.getModuleName(), "ignore", null);
        if (mode != null) {
            return mode;
        }
        this.lazyLoadModulesConfig();
        return (IgnoreSubmoduleMode)this.modulesConfig.getEnum(IgnoreSubmoduleMode.values(), "submodule", this.getModuleName(), "ignore", IgnoreSubmoduleMode.NONE);
    }

    public Repository getRepository() throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(this.repository.getWorkTree(), this.path, this.repository.getFS(), this.getBuilder());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectId getHead() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Repository subRepo = this.getRepository();){
            if (subRepo != null) return subRepo.resolve("HEAD");
            return null;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHeadRef() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Repository subRepo = this.getRepository();){
            String string;
            if (subRepo == null) {
                return null;
            }
            Ref head = subRepo.exactRef("HEAD");
            if (head != null) {
                string = head.getLeaf().getName();
                return string;
            }
            string = null;
            return string;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public String getRemoteUrl() throws IOException, ConfigInvalidException {
        String url = this.getModulesUrl();
        return url != null ? SubmoduleWalk.getSubmoduleRemoteUrl(this.repository, url) : null;
    }

    @Override
    public void close() {
        this.walk.close();
    }

    public static enum IgnoreSubmoduleMode {
        ALL,
        DIRTY,
        UNTRACKED,
        NONE;

    }
}

