/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.types.Path;
import org.eclipse.ant.internal.ui.model.AntPropertyNode;

public class AntModelProject
extends Project {
    private AntPropertyNode fCurrentConfiguringPropertyNode;
    private Map<String, Object> idrefs = Collections.synchronizedMap(new HashMap());
    private static Object loaderLock = new Object();
    private Hashtable<String, AntClassLoader> loaders = null;

    public AntModelProject() {
        PropertyHelper.getPropertyHelper((Project)this).add((PropertyHelper.Delegate)new AntPropertyHelper());
    }

    public void setNewProperty(String name, String value) {
        if (PropertyHelper.getPropertyHelper((Project)this).getProperty(name) != null) {
            return;
        }
        if (this.fCurrentConfiguringPropertyNode != null) {
            this.fCurrentConfiguringPropertyNode.addProperty(name, value);
        }
        super.setProperty(name, value);
    }

    public void fireBuildFinished(Throwable exception) {
        super.fireBuildFinished(exception);
        Enumeration e = this.getBuildListeners().elements();
        while (e.hasMoreElements()) {
            BuildListener listener = (BuildListener)e.nextElement();
            this.removeBuildListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.getTargets().clear();
        this.setDefault(null);
        this.setDescription(null);
        this.setName("");
        Object object = loaderLock;
        synchronized (object) {
            if (this.loaders != null) {
                Iterator<Map.Entry<String, AntClassLoader>> i = this.loaders.entrySet().iterator();
                Map.Entry<String, AntClassLoader> e = null;
                while (i.hasNext()) {
                    e = i.next();
                    AntClassLoader acl = e.getValue();
                    acl.cleanup();
                    acl.clearAssertionStatus();
                }
            }
        }
    }

    public String getProperty(String name) {
        String result = super.getProperty(name);
        if (result == null) {
            return this.getUserProperty(name);
        }
        return result;
    }

    public void addIdReference(String id, Object value) {
        this.idrefs.put(id, value);
    }

    public <T> T getReference(String key) {
        Object ref = super.getReference(key);
        if (ref == null && (ref = this.idrefs.get(key)) instanceof UnknownElement) {
            UnknownElement ue = (UnknownElement)ref;
            ue.maybeConfigure();
            return (T)ue.getRealThing();
        }
        return (T)ref;
    }

    public Hashtable<String, Object> getProperties() {
        Hashtable allProps = super.getProperties();
        allProps.putAll(this.getUserProperties());
        allProps.put("basedir", this.getBaseDir().getPath());
        return allProps;
    }

    public void setBaseDir(File baseDir) throws BuildException {
        super.setBaseDir(baseDir);
        this.setNewProperty("basedir", this.getBaseDir().getPath());
    }

    public void setCurrentConfiguringProperty(AntPropertyNode node) {
        this.fCurrentConfiguringPropertyNode = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AntClassLoader createClassLoader(Path path) {
        Object object = loaderLock;
        synchronized (object) {
            String pstr;
            AntClassLoader loader;
            Path p;
            if (this.loaders == null) {
                this.loaders = new Hashtable(8);
            }
            if ((p = path) == null) {
                p = new Path((Project)this);
            }
            if ((loader = this.loaders.get(pstr = p.toString())) == null) {
                loader = super.createClassLoader(path);
                if (path == null) {
                    loader.setClassPath(Path.systemClasspath);
                }
                this.loaders.put(pstr, loader);
            }
            return loader;
        }
    }

    class AntPropertyHelper
    implements PropertyHelper.PropertySetter {
        AntPropertyHelper() {
        }

        public boolean setNew(String property, Object value, PropertyHelper propertyHelper) {
            AntModelProject.this.setNewProperty(property, value.toString());
            return false;
        }

        public boolean set(String property, Object value, PropertyHelper propertyHelper) {
            return false;
        }
    }
}

