/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import org.eclipse.swt.widgets.Display;

public abstract class PeriodicDisplayTask {
    protected final int period;
    private final Display display;
    private DisplayTask task = null;

    protected PeriodicDisplayTask(Display display, int period) {
        this.period = period;
        this.display = display;
    }

    public final synchronized void start() {
        if (this.task != null) {
            this.stop();
        }
        this.task = new DisplayTask();
        this.schedule();
    }

    public final synchronized void stop() {
        if (this.task != null) {
            this.display.timerExec(-1, (Runnable)this.task);
            this.task = null;
        }
    }

    protected final synchronized void schedule() {
        if (this.task != null && !this.display.isDisposed()) {
            this.display.timerExec(this.period, (Runnable)this.task);
        }
    }

    protected abstract void update();

    public Display getDisplay() {
        return this.display;
    }

    private final class DisplayTask
    implements Runnable {
        private DisplayTask() {
        }

        @Override
        public void run() {
            PeriodicDisplayTask.this.update();
            PeriodicDisplayTask.this.schedule();
        }
    }
}

