/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.internal.UiPluginConstants;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IXNavigateEventListener;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.swt.Displays;

public class XNavigateEventManager {
    private static final Set<IXNavigateEventListener> listeners = new HashSet<IXNavigateEventListener>();

    public static void register(IXNavigateEventListener listener) {
        listeners.add(listener);
    }

    public static void itemRefreshed(final XNavigateItem item) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (IXNavigateEventListener listener : listeners) {
                    try {
                        listener.refresh(item);
                    }
                    catch (Exception ex) {
                        OseeLog.log(UiPluginConstants.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }
        });
    }
}

