/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.osee.framework.jdk.core.util.network.PortUtil;
import org.eclipse.osee.framework.jdk.core.util.xml.XmlTransformServer;

public class XmlTransformAsProcess {
    private Socket clientSocket = null;
    private InputStream inputFromNetwork = null;
    private OutputStream outputFromNetwork = null;
    private Process process = null;

    private XmlTransformAsProcess() {
    }

    private URL getClassLocation(Class<XmlTransformServer> classToFind) {
        URL result = null;
        if (classToFind == null) {
            throw new IllegalArgumentException("Class is null");
        }
        String classAsResource = classToFind.getName().replace('.', '/').concat(".class");
        ProtectionDomain pd = classToFind.getProtectionDomain();
        if (pd != null) {
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                result = cs.getLocation();
            }
            if (result != null && result.getProtocol().equals("file")) {
                try {
                    if (result.toExternalForm().endsWith(".jar") || result.toExternalForm().endsWith(".zip")) {
                        result = new URL("jar:".concat(result.toExternalForm()).concat("!/").concat(classAsResource));
                    } else if (new File(result.getFile()).isDirectory()) {
                        result = new URL(result, classAsResource);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        if (result == null) {
            ClassLoader classLoader = classToFind.getClassLoader();
            result = classLoader != null ? classLoader.getResource(classAsResource) : ClassLoader.getSystemResource(classAsResource);
        }
        return result;
    }

    private void connectToServer(InetAddress address, int port) throws Exception {
        try {
            int i = 0;
            while (i < 10) {
                try {
                    this.clientSocket = new Socket(address, port);
                    break;
                }
                catch (Throwable throwable) {
                    Thread.sleep(1000L);
                    ++i;
                }
            }
            System.out.println("Connected");
            this.inputFromNetwork = new BufferedInputStream(this.clientSocket.getInputStream());
            this.outputFromNetwork = new BufferedOutputStream(this.clientSocket.getOutputStream());
        }
        catch (Exception ex) {
            throw new Exception("Unable to Connect to Transform Server. ", ex);
        }
    }

    private void launchServer(int port) throws Exception {
        ArrayList<String> commands = new ArrayList<String>();
        try {
            URL url = this.getClassLocation(XmlTransformServer.class);
            String path = new File(url.toURI()).getAbsolutePath();
            int indexOf = path.indexOf("bin");
            path = path.substring(0, indexOf + 4);
            File classFileLocation = new File(path);
            String className = XmlTransformServer.class.getName();
            commands.add("java");
            commands.add("Xmx1024M");
            commands.add(className);
            commands.add(Integer.toString(port));
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(classFileLocation);
            builder.command(commands);
            this.process = builder.start();
            Thread.sleep(800L);
        }
        catch (URISyntaxException ex) {
            throw new Exception("Unable to find XmlTransformServer class in File System. ", ex);
        }
        catch (Exception ex) {
            throw new Exception("Unable to launch TransformServer. ", ex);
        }
    }

    public void processXml(InputStream xmlSource, InputStream xsltSource, Writer result) {
        try {
            XmlTransformServer.sendStream(this.clientSocket, xmlSource, this.outputFromNetwork);
            Thread.sleep(2000L);
            System.gc();
            System.out.println("Sent Xml");
            XmlTransformServer.sendStream(this.clientSocket, xsltSource, this.outputFromNetwork);
            System.gc();
            Thread.sleep(2000L);
            System.out.println("Sent Xslt");
            XmlTransformServer.receiveStream(this.clientSocket, this.inputFromNetwork, result);
            System.gc();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void clearResources() throws Exception {
        if (this.inputFromNetwork != null) {
            this.inputFromNetwork.close();
        }
        if (this.outputFromNetwork != null) {
            this.outputFromNetwork.close();
        }
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public static void getHtmlFromXml(InputStream xmlSource, InputStream xsltSource, Writer results) throws Exception {
        XmlTransformAsProcess xmlTransformProcess = new XmlTransformAsProcess();
        try {
            InetAddress address = InetAddress.getLocalHost();
            int port = PortUtil.getInstance().getValidPort();
            System.out.println("Transform Server at port: " + port);
            System.gc();
            xmlTransformProcess.launchServer(port);
            xmlTransformProcess.connectToServer(address, port);
            xmlTransformProcess.processXml(xmlSource, xsltSource, results);
        }
        finally {
            xmlTransformProcess.clearResources();
            System.gc();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream xmlInput = new FileInputStream(args[0]);
            try {
                try (FileInputStream xsltInput = new FileInputStream(args[1]);){
                    XmlTransformAsProcess.getHtmlFromXml(xmlInput, xsltInput, new PrintWriter(System.out));
                }
                if (xmlInput == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (xmlInput == null) throw throwable;
                ((InputStream)xmlInput).close();
                throw throwable;
            }
            ((InputStream)xmlInput).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

