/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OseeDb;

public class OseeInfo {
    private static final String GET_VALUE_SQL = "Select OSEE_VALUE FROM osee_info where OSEE_KEY = ?";
    private static final String DELETE_KEY_SQL = "DELETE FROM osee_info WHERE OSEE_KEY = ?";
    public static final String DB_ID_KEY = "osee.db.guid";
    private static Map<String, String> cache = new HashMap<String, String>();

    public static String getValue(JdbcClient jdbcClient, String key) {
        String toReturn = (String)jdbcClient.fetch((Object)"", GET_VALUE_SQL, new Object[]{key});
        cache.put(key, toReturn);
        return toReturn;
    }

    public static String getDatabaseGuid(JdbcClient jdbcClient) {
        return OseeInfo.getValue(jdbcClient, DB_ID_KEY);
    }

    public static String getCachedValue(JdbcClient jdbcClient, String key) {
        String cacheValue = cache.get(key);
        if (cacheValue == null) {
            cacheValue = OseeInfo.getValue(jdbcClient, key);
            cache.put(key, cacheValue);
        }
        return cacheValue;
    }

    public static void setValue(JdbcClient jdbcClient, String key, String value) {
        jdbcClient.runPreparedUpdate(DELETE_KEY_SQL, new Object[]{key});
        jdbcClient.runPreparedUpdate(OseeDb.OSEE_INFO_TABLE.getInsertSql(), new Object[]{key, value});
        cache.put(key, value);
    }
}

