/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;

public class WordMLApplicabilityHandler {
    private final Set<String> validConfigurations;
    private final Set<String> validConfigurationGroups;
    private final Map<String, List<String>> viewApplicabilitiesMap;
    private final Stack<ApplicabilityBlock> applicBlocks = new Stack();
    private final Log logger;
    private final OrcsApplicability applicabilityOps;
    private final BranchId branch;
    private final ArtifactToken view;

    public WordMLApplicabilityHandler(OrcsApi orcsApi, Log logger, BranchId branch, ArtifactId view) {
        this.logger = logger;
        this.applicabilityOps = orcsApi.getApplicabilityOps();
        QueryFactory query = orcsApi.getQueryFactory();
        this.branch = WordMLApplicabilityHandler.getProductLineBranch(query, branch);
        this.validConfigurations = WordMLApplicabilityHandler.getValidConfigurations(query, this.branch);
        this.validConfigurationGroups = WordMLApplicabilityHandler.getValidConfigurationGroups(query, this.branch);
        this.view = query.fromBranch(this.branch).andId(view).asArtifactToken();
        this.viewApplicabilitiesMap = orcsApi.getQueryFactory().applicabilityQuery().getNamedViewApplicabilityMap(this.branch, view);
    }

    public static BranchId getProductLineBranch(QueryFactory query, BranchId branch) {
        Branch br = (Branch)((BranchQuery)query.branchQuery().andId(branch)).getResults().getExactlyOne();
        if (br.getBranchType().equals((Object)BranchType.MERGE)) {
            branch = br.getParentBranch();
        }
        return branch;
    }

    public String previewValidApplicabilityContent(String content) {
        String toReturn = content;
        int searchIndex = 0;
        int applicBlockCount = 0;
        Matcher matcher = WordCoreUtil.FULL_PATTERN.matcher(toReturn);
        while (searchIndex < toReturn.length() && matcher.find(searchIndex)) {
            ApplicabilityBlock.ApplicabilityType type;
            String endConfig;
            String beginFeature = matcher.group(1);
            String beginConfigGroup = matcher.group(26);
            String beginConfig = matcher.group(78);
            String endFeature = matcher.group(12) != null ? WordCoreUtil.textOnly((String)matcher.group(12)).toLowerCase() : null;
            String endConfigGroup = matcher.group(53) != null ? WordCoreUtil.textOnly((String)matcher.group(53)).toLowerCase() : null;
            String string = endConfig = matcher.group(100) != null ? WordCoreUtil.textOnly((String)matcher.group(100)).toLowerCase() : null;
            if (beginFeature != null && WordCoreUtil.textOnly((String)beginFeature).toLowerCase().contains("feature")) {
                ++applicBlockCount;
                searchIndex = this.addApplicabilityBlock(ApplicabilityBlock.ApplicabilityType.Feature, matcher, beginFeature, searchIndex, toReturn);
                continue;
            }
            if (beginConfig != null && WordCoreUtil.textOnly((String)beginConfig).toLowerCase().contains("configuration")) {
                if (this.isValidConfigurationBracket(beginConfig)) {
                    ++applicBlockCount;
                    type = ApplicabilityBlock.ApplicabilityType.Configuration;
                    if (beginConfig.contains("Not")) {
                        type = ApplicabilityBlock.ApplicabilityType.NotConfiguration;
                    }
                    searchIndex = this.addApplicabilityBlock(type, matcher, beginConfig, searchIndex, toReturn);
                    continue;
                }
                searchIndex = matcher.end();
                continue;
            }
            if (beginConfigGroup != null && WordCoreUtil.textOnly((String)beginConfigGroup).toLowerCase().contains("configurationgroup")) {
                if (this.isValidConfigurationGroupBracket(beginConfigGroup)) {
                    ++applicBlockCount;
                    type = ApplicabilityBlock.ApplicabilityType.ConfigurationGroup;
                    if (beginConfigGroup.contains("Not")) {
                        type = ApplicabilityBlock.ApplicabilityType.NotConfigurationGroup;
                    }
                    searchIndex = this.addApplicabilityBlock(type, matcher, beginConfigGroup, searchIndex, toReturn);
                    continue;
                }
                searchIndex = matcher.end();
                continue;
            }
            if (!(endFeature != null && endFeature.contains("feature") || endConfig != null && endConfig.contains("configuration")) && (endConfigGroup == null || !endConfigGroup.contains("configurationgroup"))) break;
            ApplicabilityBlock applicabilityBlock = this.getFullApplicabilityBlock(matcher, toReturn);
            if (applicabilityBlock == null) {
                searchIndex = matcher.end();
                continue;
            }
            --applicBlockCount;
            String toInsert = this.evaluateApplicabilityBlock(applicabilityBlock, toReturn);
            String toReplace = toReturn.substring(applicabilityBlock.getStartInsertIndex(), applicabilityBlock.getEndInsertIndex());
            toReturn = toReturn.replace(toReplace, toInsert);
            searchIndex = applicabilityBlock.getStartInsertIndex() + (applicabilityBlock.isInTable() ? 0 : toInsert.length());
            matcher = WordCoreUtil.FULL_PATTERN.matcher(toReturn);
        }
        toReturn = WordCoreUtil.removeEmptyLists((CharSequence)toReturn).toString();
        if (applicBlockCount != 0) {
            this.logger.error("An applicability block of text is missing an End Feature/Configuration tag", new Object[0]);
        }
        return toReturn;
    }

    private boolean isValidConfigurationBracket(String beginConfig) {
        beginConfig = WordCoreUtil.textOnly((String)beginConfig);
        int start = beginConfig.indexOf("[") + 1;
        int end = beginConfig.indexOf("]");
        String applicExpText = beginConfig.substring(start, end);
        String[] configs = applicExpText.split("&|\\|");
        int i = 0;
        while (i < configs.length) {
            configs[i] = configs[i].split("=")[0].trim();
            if (!Strings.containsIgnoreCase(this.validConfigurations, (String)configs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isValidConfigurationGroupBracket(String beginConfigGroup) {
        beginConfigGroup = WordCoreUtil.textOnly((String)beginConfigGroup);
        int start = beginConfigGroup.indexOf("[") + 1;
        int end = beginConfigGroup.indexOf("]");
        String applicExpText = beginConfigGroup.substring(start, end);
        String[] configGroups = applicExpText.split("&|\\|");
        int i = 0;
        while (i < configGroups.length) {
            configGroups[i] = configGroups[i].split("=")[0].trim();
            if (!Strings.containsIgnoreCase(this.validConfigurationGroups, (String)configGroups[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isValidFeatureBracket(String optionalEndBracket) {
        String[] featureValueStrings;
        String text = WordCoreUtil.textOnly((String)optionalEndBracket);
        text = text.replaceAll("\\[", "");
        text = text.replaceAll("\\]", "").trim();
        String[] stringArray = featureValueStrings = text.split("\\||&");
        int n = featureValueStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String featVal;
            String featureValueString = stringArray[n2];
            String[] split = featureValueString.split("=");
            String featName = split[0].trim().toUpperCase();
            String string = featVal = split.length > 1 ? split[1].trim() : null;
            if (this.viewApplicabilitiesMap.containsKey(featName)) {
                List<String> values = this.viewApplicabilitiesMap.get(featName);
                if (featVal != null && !Strings.containsIgnoreCase(values, (String)featVal)) {
                    return false;
                }
            } else {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String evaluateApplicabilityBlock(ApplicabilityBlock applicabilityBlock, String fullWordML) {
        TreeMap<String, String> binDataMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this.saveBinData(applicabilityBlock.getInsideText(), binDataMap);
        String toInsert = this.applicabilityOps.evaluateApplicabilityExpression(this.branch, this.view, applicabilityBlock);
        return this.insertMissingbinData(toInsert, binDataMap);
    }

    private String insertMissingbinData(String toInsert, Map<String, String> binDataMap) {
        String temp = toInsert;
        Matcher matcher = WordCoreUtil.IMG_SRC_PATTERN.matcher(temp);
        while (matcher.find()) {
            String binData;
            String srcId = matcher.group(1);
            if (!binDataMap.containsKey(srcId) || temp.contains(binData = binDataMap.get(srcId))) continue;
            temp = String.valueOf(binData) + temp;
        }
        return temp;
    }

    private void saveBinData(String fullText, Map<String, String> binDataMap) {
        Matcher matcher = WordCoreUtil.BIN_DATA_PATTERN.matcher(fullText);
        while (matcher.find()) {
            binDataMap.put(matcher.group(1), matcher.group(0));
        }
    }

    private int addApplicabilityBlock(ApplicabilityBlock.ApplicabilityType type, Matcher matcher, String applicabilityExpression, int searchIndex, String fullWordMl) {
        ApplicabilityBlock beginApplic = new ApplicabilityBlock(type);
        String applicExpText = WordCoreUtil.textOnly((String)applicabilityExpression).toLowerCase().replace(" [", "[");
        beginApplic.setApplicabilityExpression(applicExpText);
        beginApplic.setStartInsertIndex(matcher.start());
        beginApplic.setStartTextIndex(matcher.end());
        beginApplic.setBeginTag(applicabilityExpression);
        this.applicBlocks.push(beginApplic);
        searchIndex = matcher.end();
        return searchIndex;
    }

    private ApplicabilityBlock getFullApplicabilityBlock(Matcher matcher, String toReturn) {
        String findEndOfRow;
        int endRowIndex;
        String findStartOfRow;
        int startRowIndex;
        int endBracketGroup;
        if (this.applicBlocks.isEmpty()) {
            this.logger.error("An applicability block of text is missing a start Feature/Configuration tag", new Object[0]);
            return null;
        }
        ApplicabilityBlock applic = this.applicBlocks.pop();
        String optionalEndBracket = null;
        boolean isValidBracket = false;
        if (applic.getType().equals((Object)ApplicabilityBlock.ApplicabilityType.ConfigurationGroup)) {
            endBracketGroup = 75;
            optionalEndBracket = matcher.group(endBracketGroup);
            isValidBracket = optionalEndBracket == null ? false : this.isValidConfigurationGroupBracket(optionalEndBracket);
        } else if (applic.getType().equals((Object)ApplicabilityBlock.ApplicabilityType.Configuration)) {
            endBracketGroup = 117;
            optionalEndBracket = matcher.group(endBracketGroup);
            isValidBracket = optionalEndBracket == null ? false : this.isValidConfigurationBracket(optionalEndBracket);
        } else {
            endBracketGroup = 23;
            optionalEndBracket = matcher.group(endBracketGroup);
            boolean bl = isValidBracket = optionalEndBracket == null ? false : this.isValidFeatureBracket(optionalEndBracket);
        }
        if (optionalEndBracket != null && !isValidBracket) {
            int newEndInsertIndex = matcher.end() - optionalEndBracket.length();
            applic.setEndInsertIndex(newEndInsertIndex);
        } else {
            applic.setEndInsertIndex(matcher.end());
        }
        applic.setEndTextIndex(matcher.start());
        String insideText = toReturn.substring(applic.getStartTextIndex(), applic.getEndTextIndex());
        applic.setInsideText(insideText);
        if (!applic.getInsideText().contains("<w:tbl>") && applic.getInsideText().contains("<w:tc>") && (startRowIndex = (findStartOfRow = toReturn.substring(0, applic.getStartInsertIndex())).lastIndexOf("<w:tr wsp:rsidR=")) != -1 && (endRowIndex = (findEndOfRow = toReturn.substring(matcher.end())).indexOf("</w:tr>")) != -1) {
            endRowIndex = endRowIndex + matcher.end() + 7;
            String fullText = toReturn.substring(startRowIndex, endRowIndex);
            applic.setIsInTable(true);
            applic.setStartInsertIndex(startRowIndex);
            applic.setEndInsertIndex(startRowIndex + fullText.length());
            fullText = fullText.replaceFirst("(?i)(E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?|E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?|E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?)", "");
            fullText = fullText.replaceFirst("(?i)(F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?|C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p(\\<[^>]*?>){0,30}( (\\<[^>]*?>){0,30}N(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30})? ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?|C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}( (\\<[^>]*?>){0,30}N(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30})? ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?)", "");
            applic.setInsideText(fullText);
        }
        return applic;
    }

    public static HashSet<String> getValidConfigurations(QueryFactory query, BranchId branch) {
        HashSet<String> validConfigurations = new HashSet<String>();
        List views = query.fromBranch(branch).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).asArtifactTokens();
        for (ArtifactToken view : views) {
            validConfigurations.add(view.getName().toUpperCase());
        }
        return validConfigurations;
    }

    public static HashSet<String> getValidConfigurationGroups(QueryFactory query, BranchId branch) {
        HashSet<String> validConfigurationGroups = new HashSet<String>();
        List views = query.fromBranch(branch).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelationExists(CoreRelationTypes.PlConfigurationGroup_Group).asArtifactTokens();
        for (ArtifactToken view : views) {
            validConfigurationGroups.add(view.getName().toUpperCase());
        }
        return validConfigurationGroups;
    }
}

