/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.define.api.DefineOperations;
import org.eclipse.osee.define.api.MsWordPreviewRequestData;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.api.WordUpdateChange;
import org.eclipse.osee.define.api.WordUpdateData;
import org.eclipse.osee.define.api.publishing.PublishingOperations;
import org.eclipse.osee.define.api.publishing.PublishingOptions;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplate;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.operations.publishing.AttachmentFactory;
import org.eclipse.osee.define.operations.publishing.MSWordPreviewPublisher;
import org.eclipse.osee.define.operations.publishing.MSWordTemplatePublisher;
import org.eclipse.osee.define.operations.publishing.PublishingErrorLog;
import org.eclipse.osee.define.operations.publishing.PublishingOptionsFactory;
import org.eclipse.osee.define.operations.publishing.PublishingSharedArtifactsFolder;
import org.eclipse.osee.define.operations.publishing.PublishingUtils;
import org.eclipse.osee.define.operations.publishing.WordCoreUtilServer;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMLApplicabilityHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMlLinkHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordTemplateContentRendererHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordUpdateArtifact;
import org.eclipse.osee.define.util.Validation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.core.util.LinkType;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.osgi.service.event.EventAdmin;

public class PublishingOperationsImpl
implements PublishingOperations {
    private static final boolean excludeFolders = true;
    private static final boolean includeFolders = false;
    private static PublishingOperationsImpl publishingOperationsImpl = null;
    private static final PublishingOptionsFactory<DocumentType> publishingOptionsFactory = PublishingOptionsFactory.ofEntries(DocumentType.class, DocumentType::getPublishingOptions);
    private final AtsApi atsApi;
    private final DefineOperations defineOperations;
    private final EventAdmin eventAdmin;
    private final Log logger;
    private final OrcsApi orcsApi;
    private final AttachmentFactory attachmentFactory;

    public static synchronized PublishingOperationsImpl create(DefineOperations defineOperations, OrcsApi orcsApi, AtsApi atsApi, Log logger, EventAdmin eventAdmin) {
        return Objects.isNull(publishingOperationsImpl) ? (publishingOperationsImpl = new PublishingOperationsImpl(defineOperations, orcsApi, atsApi, logger, eventAdmin)) : publishingOperationsImpl;
    }

    private PublishingOperationsImpl(DefineOperations defineOperations, OrcsApi orcsApi, AtsApi atsApi, Log logger, EventAdmin eventAdmin) {
        this.defineOperations = defineOperations;
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.logger = logger;
        this.eventAdmin = eventAdmin;
        this.attachmentFactory = new AttachmentFactory("MsWordPreview", "xml", this.orcsApi);
    }

    public List<ArtifactToken> getSharedPublishingArtifacts(BranchId branch, ArtifactId view, ArtifactId sharedFolder, ArtifactTypeToken artifactType, AttributeTypeToken attributeType, String attributeValue) {
        Message message = null;
        message = Validation.verifyParameter(branch, "branch", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(view, "view", message, "with an Id less than minus one", p -> p.getId() < -1L);
        message = Validation.verifyParameter(sharedFolder, "sharedFolder", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(artifactType, "artifactType", message, "with an Id less than minus one", p -> p.getId() < -1L);
        message = Validation.verifyParameter(attributeType, "attributeType", message, "with an Id less than minus one", p -> p.getId() < -1L);
        if (Objects.nonNull(message = Validation.verifyParameter(attributeValue, "attributeValue", message, "empty string", p -> p.isEmpty()))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "getSharedPublishingArtifacts", message));
        }
        PublishingUtils publishingUtils = new PublishingUtils(this.orcsApi);
        PublishingErrorLog publishingErrorLog = new PublishingErrorLog();
        PublishingSharedArtifactsFolder publishingSharedArtifactsFolder = ArtifactTypeToken.SENTINEL.equals(artifactType) ? PublishingSharedArtifactsFolder.create(publishingUtils, publishingErrorLog, BranchId.create((Long)branch.getId(), (ArtifactId)view), "Shared Artifacts Folder", ArtifactToken.valueOf((long)sharedFolder.getId(), (BranchId)branch), (AttributeTypeId)attributeType) : PublishingSharedArtifactsFolder.create(publishingUtils, publishingErrorLog, BranchId.create((Long)branch.getId(), (ArtifactId)view), "Shared Artifacts Folder", ArtifactToken.valueOf((long)sharedFolder.getId(), (BranchId)branch), artifactType, (AttributeTypeId)attributeType);
        List<ArtifactReadable> sharedArtifacts = publishingSharedArtifactsFolder.getSharedArtifacts(attributeValue);
        if (publishingErrorLog.size() > 0) {
            StringBuilder errorLogMessage = new StringBuilder(1024);
            publishingErrorLog.publishErrorLog(errorLogMessage);
            throw new OseeNotFoundException(errorLogMessage.toString(), new Object[0]);
        }
        List<ArtifactReadable> sharedArtifactTokens = sharedArtifacts;
        return sharedArtifactTokens;
    }

    public Attachment msWordPreview(BranchId branch, ArtifactId templateArtifactId, ArtifactId headArtifact, ArtifactId view) {
        Message message = null;
        message = Validation.verifyParameter(branch, "branch", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(templateArtifactId, "templateArtifactId", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(headArtifact, "headArtifact", message, "with an Id less than zero", p -> p.getId() < 0L);
        if (Objects.nonNull(message = Validation.verifyParameter(view, "view", message, "with an Id less than minus one", p -> p.getId() < -1L))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "msWordPreview", message));
        }
        Attachment attachment = this.msWordPreviewInternal(new MsWordPreviewRequestData(new PublishingTemplateRequest("AT-" + templateArtifactId.getIdString()), BranchId.create((Long)branch.getId(), (ArtifactId)view), List.of(headArtifact)), false);
        return attachment;
    }

    public Attachment msWordPreview(BranchId branch, ArtifactId templateArtifactId, List<ArtifactId> artifacts, ArtifactId view) {
        Message message = null;
        message = Validation.verifyParameter(branch, "branch", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(templateArtifactId, "templateArtifactId", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(view, "view", message, "with an Id less than minus one", p -> p.getId() < -1L);
        if (Objects.nonNull(message = Validation.verifyParameter(artifacts, "artifact", message, "an empty list, or with an Id entry less than zero", p -> p.isEmpty() || p.stream().map(Id::getId).min(Long::compare).get() < 0L))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "msWordPreview", message));
        }
        Attachment attachment = this.msWordPreviewInternal(new MsWordPreviewRequestData(new PublishingTemplateRequest("AT-" + templateArtifactId.getIdString()), BranchId.create((Long)branch.getId(), (ArtifactId)view), artifacts), false);
        return attachment;
    }

    public Attachment msWordPreview(MsWordPreviewRequestData msWordPreviewRequestData) {
        Message message = null;
        if (Objects.nonNull(message = Validation.verifyParameter(msWordPreviewRequestData, "msWordPreviewRequestData", message, "is invalid", p -> !p.isValid()))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "msWordPreview", message));
        }
        return this.msWordPreviewInternal(msWordPreviewRequestData, false);
    }

    private Attachment msWordPreviewInternal(MsWordPreviewRequestData msWordPreviewRequestData, boolean folderInclusion) {
        BranchId branchId = msWordPreviewRequestData.getBranchId();
        ArtifactId viewId = branchId.getViewId();
        ArtifactId firstArtifactId = (ArtifactId)msWordPreviewRequestData.getArtifactIds().get(0);
        PublishingTemplate publishingTemplate = this.defineOperations.getTemplateManagerOperations().getPublishingTemplate(msWordPreviewRequestData.getPublishingTemplateRequest());
        if (publishingTemplate.isSentinel()) {
            String message = new Message().title((CharSequence)"PublishingOperationsImpl::msWordPreviewInternal: Failed to find a publishing template.").indentInc().toMessage((ToMessage)msWordPreviewRequestData).toString();
            this.logger.error(message, new Object[0]);
            throw new OseeCoreException(message, new Object[0]);
        }
        PublishingOptions publishingOptions = publishingOptionsFactory.create(DocumentType.PREVIEW_WITH_FOLDERS, branchId, viewId);
        List publishArtifacts = msWordPreviewRequestData.getArtifactIds();
        var outputStream = new ByteArrayOutputStream(){

            byte[] getBuffer() {
                return this.buf;
            }
        };
        try {
            Throwable throwable = null;
            Object var11_14 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
                MSWordPreviewPublisher publisher = new MSWordPreviewPublisher(publishingOptions, publishingTemplate, writer, this.orcsApi, this.atsApi);
                publisher.publish(publishArtifacts);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new OseeCoreException(new Message().title((CharSequence)"PublishingOperationsImpl::msWordPreviewIntenal, Failed to publish document.").indentInc().segment((CharSequence)"Publishing Branch Id", (Object)publishingOptions.branch.getIdString()).segment((CharSequence)"Publishing View Id", (Object)publishingOptions.view.getIdString()).segment((CharSequence)"Publish Artifacts", (Object)(Objects.nonNull(publishArtifacts) ? (publishArtifacts.size() > 0 ? publishArtifacts.stream().map(Object::toString).collect(Collectors.joining(", ", "[ ", " ]")) : "(no artifacts to publish specified)") : "(no artifacts to publish specified)")).reasonFollows((Throwable)e).toString(), (Throwable)e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.getBuffer(), 0, outputStream.size());
        Attachment attachment = this.attachmentFactory.create((InputStream)inputStream, (CharSequence)DocumentType.PREVIEW_WITH_FOLDERS.name(), branchId, firstArtifactId, new CharSequence[0]);
        return attachment;
    }

    public Attachment msWordTemplatePublish(BranchId branch, ArtifactId templateArtifactId, ArtifactId headArtifact, ArtifactId view) {
        Message message = null;
        message = Validation.verifyParameter(branch, "branch", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(templateArtifactId, "templateArtifactId", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(headArtifact, "headArtifact", message, "with an Id less than zero", p -> p.getId() < 0L);
        if (Objects.nonNull(message = Validation.verifyParameter(view, "view", message, "with an Id less than minus one", p -> p.getId() < -1L))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "msWordTemplatePublish", message));
        }
        PublishingTemplateRequest publishingTemplateRequest = new PublishingTemplateRequest("AT-" + templateArtifactId.getIdString());
        PublishingTemplate publishingTemplate = this.defineOperations.getTemplateManagerOperations().getPublishingTemplate(publishingTemplateRequest);
        PublishingOptions publishingOptions = publishingOptionsFactory.create(DocumentType.PREVIEW_WITHOUT_FOLDERS, branch, view);
        List<ArtifactId> publishArtifacts = List.of(headArtifact);
        var outputStream = new ByteArrayOutputStream(){

            byte[] getBuffer() {
                return this.buf;
            }
        };
        try {
            Throwable throwable = null;
            Object var12_14 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
                MSWordTemplatePublisher publisher = new MSWordTemplatePublisher(publishingOptions, publishingTemplate, writer, this.orcsApi, this.atsApi);
                publisher.publish(publishArtifacts);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new OseeCoreException(new Message().title((CharSequence)"PublishingOperationsImpl::msWordTemplatePublish, Failed to publish document.").indentInc().segment((CharSequence)"Publishing Branch Id", (Object)publishingOptions.branch.getIdString()).segment((CharSequence)"Publishing View Id", (Object)publishingOptions.view.getIdString()).segment((CharSequence)"Publish Artifacts", (Object)(Objects.nonNull(publishArtifacts) ? (publishArtifacts.size() > 0 ? publishArtifacts.stream().map(Object::toString).collect(Collectors.joining(", ", "[ ", " ]")) : "(no artifacts to publish specified)") : "(no artifacts to publish specified)")).reasonFollows((Throwable)e).toString(), (Throwable)e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.getBuffer(), 0, outputStream.size());
        Attachment attachment = this.attachmentFactory.create((InputStream)inputStream, (CharSequence)DocumentType.PREVIEW_WITHOUT_FOLDERS.name(), branch, headArtifact, new CharSequence[0]);
        return attachment;
    }

    public String renderPlainText(BranchId branchId, String data) {
        int lastIndex;
        String PL_STYLE_WITH_RETURN = "<w:rPr><w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>)).*?</w:rPr>";
        String PL_STYLE = "<w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>))";
        String PL_HIGHLIGHT = "<w:highlight w:val=\"light-gray\"></w:highlight><w:shd w:color=\"auto\" w:fill=\"BFBFBF\" w:val=\"clear\"></w:shd>";
        String EMPTY_PARAGRAPHS = "<w:r wsp:rsidRPr=\"\\d+\"><w:t></w:t></w:r>";
        data = WordCoreUtilServer.reassignBinDataID(data);
        data = WordMlLinkHandler.renderPlainTextWithoutLinks(this.orcsApi.getQueryFactory(), branchId, data);
        data = WordCoreUtilServer.reassignBookMarkID(data).toString();
        data = WordCoreUtilServer.removeNewLines(data);
        CharSequence charSequenceData = WordCoreUtil.removeFootersAndNoDataRightsStatements((CharSequence)data);
        if (!(data = WordCoreUtil.replaceEmptySectionBreaksWithPageBreaks((CharSequence)charSequenceData).toString()).contains("<w:tbl>") && (lastIndex = data.lastIndexOf("<w:p wsp:rsidR=")) != -1) {
            String temp = data.substring(lastIndex);
            temp = temp.replaceAll("<w:p\\s[^>]*>(<w:pPr><w:spacing[^>]*></w:spacing></w:pPr>)?</w:p>", "");
            data = String.valueOf(data.substring(0, lastIndex)) + temp;
        }
        data = data.replaceAll(PL_STYLE_WITH_RETURN, "");
        data = data.replaceAll(PL_STYLE, "");
        data = data.replaceAll(PL_HIGHLIGHT, "");
        data = data.replaceAll(EMPTY_PARAGRAPHS, "");
        data = WordCoreUtil.removeReviewComments((CharSequence)data).toString();
        return data;
    }

    public Pair<String, Set<String>> renderWordTemplateContent(WordTemplateContentData wordTemplateContentData) {
        Message message = null;
        if (Objects.nonNull(message = Validation.verifyParameter(wordTemplateContentData, "wordTemplateContentData", message, "is invalid", p -> !p.isValid()))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "renderWordTemplateContent", message));
        }
        WordTemplateContentRendererHandler wordRendererHandler = new WordTemplateContentRendererHandler(this.orcsApi, this.logger);
        return wordRendererHandler.renderWordML(wordTemplateContentData);
    }

    public String renderWordTemplateContentWithApplicability(BranchId branchId, ArtifactId viewId, String data) {
        WordMLApplicabilityHandler wordHandler = new WordMLApplicabilityHandler(this.orcsApi, this.logger, branchId, viewId);
        return wordHandler.previewValidApplicabilityContent(data);
    }

    public WordUpdateChange updateWordArtifacts(WordUpdateData wordUpdateData) {
        Message message = null;
        if (Objects.nonNull(message = Validation.verifyParameter(wordUpdateData, "wordUpdateData", message, "is invalid", p -> !p.isValid()))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "updateWordArtifacts", message));
        }
        WordUpdateArtifact updateArt = new WordUpdateArtifact(this.logger, this.orcsApi, this.eventAdmin);
        return updateArt.updateArtifacts(wordUpdateData);
    }

    private static enum DocumentType {
        PREVIEW_WITH_FOLDERS("Publish Preview With Folders", new PublishingOptions(false, LinkType.INTERNAL_DOC_REFERENCE_USE_NAME, 9)),
        PREVIEW_WITHOUT_FOLDERS("Publish Preview Without Folders", new PublishingOptions(true, LinkType.INTERNAL_DOC_REFERENCE_USE_NAME, 9));

        private PublishingOptions publishingOptions;
        private String threadName;

        private DocumentType(String threadName, PublishingOptions publishingOptions) {
            this.threadName = threadName;
            this.publishingOptions = publishingOptions;
        }

        PublishingOptions getPublishingOptions() {
            return this.publishingOptions;
        }

        String getThreadName() {
            return this.threadName;
        }
    }
}

