/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.metrics;

import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.metrics.MetricsEndpointApi;
import org.eclipse.osee.ats.rest.metrics.MetricsReportOperations;
import org.eclipse.osee.orcs.OrcsApi;

@Path(value="metrics")
public class MetricsEndpointImpl
implements MetricsEndpointApi {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public MetricsEndpointImpl(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    @Path(value="DevProgress/{targetVersion}")
    @GET
    @Produces(value={"application/octet-stream"})
    public Response devProgressReport(@PathParam(value="targetVersion") String targetVersion, @QueryParam(value="startDate") Date startDate, @QueryParam(value="endDate") Date endDate, @QueryParam(value="allTime") boolean allTime) {
        return new MetricsReportOperations(this.atsApi, this.orcsApi).generateDevProgressReport(targetVersion, startDate, endDate, allTime);
    }

    @Path(value="SoftwareReqVolatility/{targetVersion}")
    @GET
    @Produces(value={"application/octet-stream"})
    public Response softwareReqVolatility(@PathParam(value="targetVersion") String targetVersion, @QueryParam(value="startDate") Date startDate, @QueryParam(value="endDate") Date endDate, @QueryParam(value="allTime") boolean allTime, @QueryParam(value="implDetails") boolean implDetails) {
        return new MetricsReportOperations(this.atsApi, this.orcsApi).generateSoftwareReqVolatility(targetVersion, startDate, endDate, allTime, implDetails);
    }

    @Path(value="BranchDiffData/{atsId}")
    @POST
    public Response setBranchDiffData(@PathParam(value="atsId") String atsId) {
        return new MetricsReportOperations(this.atsApi, this.orcsApi).setBranchDiffData(atsId);
    }
}

