/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.operations;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.ats.rest.internal.AtsApplication;
import org.eclipse.osee.ats.rest.internal.workitem.operations.ConvertWorkDefinitionOperations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class ConvertWorkDefinitionToAttributes
implements IAtsDatabaseConversion {
    public void run(XResultData data, boolean reportOnly, AtsApi atsApi) {
        if (reportOnly) {
            data.log("No REPORT-ONLY available for this conversion.\n");
        } else {
            ConvertWorkDefinitionOperations ops = new ConvertWorkDefinitionOperations(atsApi, AtsApplication.getOrcsApi());
            ops.convert(data);
            data.log("Complete");
        }
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("Convert ATS Work Definitions from computed to Artifact Reference Attribute (required)\n\n");
        data.append("Necessary for upgrade from 0.26.0 to 0.27.0.\n\n");
        data.append("This will:\n   ---- Create a Work Definition Artifact related Attribute for each Work Item\n   ---- Create a Work Definition Artifact related Attribute for each Team Definition that has one of attrs below\nCan be run multiple times without corruption.\nShould be run periodically on 0.26.0 and once more after 0.27.0 release.\nAfter final run, the following can be removed from db:\n   --- Work Definition\n   --- Related Task Work Definition\n   --- Related Peer Workflow Definition");
        return data.toString();
    }

    public String getName() {
        return "Create Work Definition Reference Attributes";
    }
}

