/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.core.util.AbstractRelationResolverServiceImpl;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsRelationResolverServiceImpl
extends AbstractRelationResolverServiceImpl {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public AtsRelationResolverServiceImpl(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public Collection<ArtifactToken> getRelated(ArtifactId artifact, RelationTypeSide relationType) {
        ArrayList<ArtifactToken> results = new ArrayList<ArtifactToken>();
        for (ArtifactReadable art : this.getArtifact(artifact).getRelated(relationType)) {
            if (art == null) continue;
            results.add((ArtifactToken)art);
        }
        return results;
    }

    public <T extends IAtsObject> Collection<T> getRelated(IAtsObject atsObject, RelationTypeSide relationType, Class<T> clazz) {
        return this.getRelated(atsObject, relationType, DeletionFlag.EXCLUDE_DELETED, clazz);
    }

    public <T extends IAtsObject> Collection<T> getRelated(IAtsObject atsObject, RelationTypeSide relationType, DeletionFlag flag, Class<T> clazz) {
        ArrayList<IAtsObject> results = new ArrayList<IAtsObject>();
        if (atsObject.isInvalid()) {
            return results;
        }
        ArtifactReadable useArt = this.getArtifact(atsObject);
        if (useArt != null) {
            for (ArtifactReadable art : useArt.getRelated(relationType, flag)) {
                IAtsObject object = AtsObjects.getAtsObject((ArtifactToken)art, (AtsApi)this.atsApi);
                if (object == null) continue;
                results.add(object);
            }
        }
        return results;
    }

    public boolean areRelated(ArtifactId artifact1, RelationTypeSide relationType, ArtifactId artifact2) {
        boolean related = false;
        if (artifact1 instanceof ArtifactReadable && artifact2 instanceof ArtifactReadable) {
            related = this.getArtifact(artifact1).areRelated(relationType, this.getArtifact(artifact2));
        }
        return related;
    }

    public ArtifactToken getRelatedOrNull(ArtifactId artifact, RelationTypeSide relationType) {
        ArtifactToken related = null;
        try {
            related = (ArtifactToken)this.getArtifact(artifact).getRelated(relationType).getAtMostOneOrNull();
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        return related;
    }

    public ArtifactToken getRelatedOrSentinel(ArtifactId artifact, RelationTypeSide relationType) {
        ArtifactReadable related = ArtifactReadable.SENTINEL;
        try {
            related = (ArtifactToken)this.getArtifact(artifact).getRelated(relationType).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        return related;
    }

    public boolean areRelated(IAtsObject atsObject1, RelationTypeSide relationType, IAtsObject atsObject2) {
        boolean related = false;
        ArtifactReadable useArt1 = this.getArtifact(atsObject1);
        ArtifactReadable useArt2 = this.getArtifact(atsObject2);
        if (useArt1 != null && useArt2 != null) {
            related = useArt1.areRelated(relationType, useArt2);
        }
        return related;
    }

    public <T> T getRelatedOrNull(IAtsObject atsObject, RelationTypeSide relationType, Class<T> clazz) {
        IAtsObject related = null;
        ArtifactReadable art = this.getArtifact(atsObject);
        if (art != null) {
            try {
                IAtsObject object;
                ArtifactReadable artifact = (ArtifactReadable)art.getRelated(relationType).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
                if (artifact.isValid() && (object = AtsObjects.getAtsObject((ArtifactToken)artifact, (AtsApi)this.atsApi)) != null) {
                    related = object;
                }
            }
            catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        }
        return (T)related;
    }

    public ArtifactReadable getArtifact(Object object) {
        ArtifactReadable useArt = null;
        if (object instanceof ArtifactReadable) {
            useArt = (ArtifactReadable)object;
        } else if (object instanceof IAtsObject) {
            IAtsObject atsObject = (IAtsObject)object;
            useArt = atsObject.getStoreObject() instanceof ArtifactReadable ? (ArtifactReadable)atsObject.getStoreObject() : (ArtifactReadable)this.atsApi.getQueryService().getArtifact(atsObject.getId());
        } else if (object instanceof ArtifactId) {
            useArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(((ArtifactId)object).getId());
        }
        return useArt;
    }

    public int getRelatedCount(IAtsWorkItem workItem, RelationTypeSide relationType) {
        ArtifactReadable artifact = this.getArtifact(workItem);
        int count = 0;
        if (artifact != null) {
            count = artifact.getRelatedCount(relationType);
        }
        return count;
    }

    public ArtifactToken getRelatedOrNull(IAtsObject atsObject, RelationTypeSide relationSide) {
        ArtifactReadable art = this.getArtifact(atsObject);
        if (art != null) {
            return (ArtifactToken)art.getRelated(relationSide).getAtMostOneOrNull();
        }
        return null;
    }

    public ArtifactToken getRelatedOrSentinel(IAtsObject atsObject, RelationTypeSide relationSide) {
        ArtifactReadable art = this.getArtifact(atsObject);
        if (art != null) {
            return (ArtifactToken)art.getRelated(relationSide).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        }
        return ArtifactReadable.SENTINEL;
    }

    public Collection<ArtifactToken> getRelatedArtifacts(IAtsWorkItem workItem, RelationTypeSide relationTypeSide) {
        ArtifactReadable artifact = this.getArtifact(workItem);
        return Collections.castAll(this.getRelated((ArtifactId)artifact, relationTypeSide));
    }

    public Collection<ArtifactToken> getRelated(ArtifactId artifact, RelationTypeSide relationType, ArtifactTypeToken artifactType) {
        LinkedList<ArtifactToken> results = new LinkedList<ArtifactToken>();
        ArtifactReadable art = this.getArtifact(artifact);
        for (ArtifactToken related : art.getRelated(relationType)) {
            if (!((ArtifactReadable)related).isOfType(new ArtifactTypeId[]{artifactType})) continue;
            results.add(related);
        }
        return results;
    }

    public Collection<ArtifactToken> getRelatedArtifacts(ArtifactId artifact, RelationTypeSide relationTypeSide) {
        return this.getRelated(artifact, relationTypeSide);
    }

    public int getRelatedCount(ArtifactToken artifact, RelationTypeSide relationTypeSide) {
        ArtifactReadable art = this.getArtifact(artifact);
        return art.getRelatedCount(relationTypeSide);
    }

    public List<ArtifactId> getRelatedIds(ArtifactId artifact, RelationTypeSide relationTypeSide) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId(artifact);
        List artifactIds = query.follow(relationTypeSide).asArtifactIds();
        artifactIds.remove(artifact);
        return artifactIds;
    }

    public Collection<IRelationLink> getRelations(ArtifactId artifact, RelationTypeSide relationTypeSide) {
        ArtifactReadable art = this.getArtifact(artifact);
        return art.getRelations(relationTypeSide).getList();
    }
}

