/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workdef.model.CompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class ActionPage {
    private static final String DEFECT_TABLE_HEADER = "<table border=\"1\" align=\"center\" width=\"98%\"><tr><th>Severity</th><th>Disposition</th><th>Closed</th><th>User</th><th>Created</th><th>Injected</th><th>Description</th><th>Location</th><th>Resolution</th></tr>";
    private static final String ROLE_TABLE_HEADER = "<table border=\"1\" align=\"center\" width=\"90%\"><tr><th>Role</th><th>User</th><th>Completed</th><th>Hours Spent</th></tr>";
    private static final String COMMIT_MANAGER_WIDGET_NAME = "Commit Manager";
    private static final String REVIEW_DEFECT_WIDGET_NAME = "Review Defect";
    private static final String ROLE_WIDGET_NAME = "Role";
    private String pageTemplate;
    private IAtsWorkItem workItem;
    private final ArtifactReadable action;
    private final AtsApi atsApi;
    private final Log logger;
    private boolean addTransition = false;
    private static final List<String> roleKeys = Arrays.asList("role", "userId", "completed", "hoursSpent");
    private static final List<String> defectKeys = Arrays.asList("severity", "disposition", "closed", "user", "date", "injectionActivity", "description", "location", "resolution");
    private static List<String> ignoredWidgets;
    private final boolean details;
    private boolean inComposite = false;

    public ActionPage(Log logger, AtsApi atsApi, IAtsWorkItem workItem, boolean details) {
        this(logger, atsApi, (ArtifactReadable)workItem.getStoreObject(), details);
        this.workItem = workItem;
    }

    public ActionPage(Log logger, AtsApi atsApi, ArtifactReadable action, boolean details) {
        this.logger = logger;
        this.atsApi = atsApi;
        this.action = action;
        this.details = details;
    }

    private IAtsWorkItem getWorkItem() {
        if (this.workItem == null) {
            this.workItem = this.atsApi.getWorkItemService().getWorkItem((ArtifactToken)this.action);
        }
        return this.workItem;
    }

    public ViewModel generate() throws Exception {
        IAtsWorkItem workItem = this.getWorkItem();
        Conditions.checkNotNull((Object)workItem, (String)"workItem");
        ViewModel page = new ViewModel("action.html");
        page.param("title", (Object)this.action.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.Title, ""));
        page.param("team", (Object)ActionPage.getTeamStr(this.atsApi, this.action));
        page.param("ais", (Object)this.getAIStr(this.action));
        page.param("state", (Object)this.atsApi.getWorkItemService().getCurrentStateName(workItem));
        page.param("assignees", (Object)ActionPage.getAssigneesStr(workItem, this.action));
        page.param("id", (Object)workItem.getId());
        page.param("atsId", (Object)workItem.getAtsId());
        page.param("originator", (Object)ActionPage.getCreatedByStr(workItem, this.action));
        page.param("priority", (Object)this.action.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.Priority, ""));
        page.param("changeType", (Object)this.action.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.ChangeType, ""));
        page.param("needBy", (Object)this.action.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.NeedBy, ""));
        page.param("workflow", (Object)this.action.getArtifactType().toString());
        page.param("createdDate", (Object)workItem.getCreatedDate().toString());
        page.param("version", (Object)this.getVersion(workItem));
        page.param("workDef", (Object)this.getWorkDefStr(workItem));
        if (!this.addTransition) {
            page.param("transition", (Object)"");
        } else {
            this.addTransitionStates(page);
        }
        this.addStates(page, workItem, this.action);
        this.addDetails(page, workItem, this.action);
        return page;
    }

    private String getWorkDefStr(IAtsWorkItem workItem) {
        return workItem.getWorkDefinition().getName();
    }

    public static String getAssigneesStr(IAtsWorkItem workItem, ArtifactReadable action) {
        return workItem.getStateMgr().getAssigneesStr();
    }

    public static String getTeamStr(AtsApi atsApi, ArtifactReadable action) {
        String results = "";
        ArtifactId artId = atsApi.getAttributeResolver().getSoleArtifactIdReference((ArtifactToken)action, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, ArtifactId.SENTINEL);
        if (artId.isValid()) {
            results = atsApi.getQueryService().getArtifact(artId).getName();
        } else {
            ArtifactReadable teamWf = ActionPage.getParentTeamWf(action);
            if (teamWf != null && teamWf.isValid() && teamWf.notEqual((Id)action)) {
                results = ActionPage.getTeamStr(atsApi, teamWf);
            }
        }
        return results;
    }

    private static ArtifactReadable getParentTeamWf(ArtifactReadable action) {
        ArtifactReadable teamWf = null;
        if (action.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            teamWf = action;
        } else if (action.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractReview})) {
            teamWf = (ArtifactReadable)action.getRelated(AtsRelationTypes.TeamWorkflowToReview_TeamWorkflow).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        } else if (action.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
            teamWf = (ArtifactReadable)action.getRelated(AtsRelationTypes.TeamWfToTask_TeamWorkflow).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        }
        return teamWf;
    }

    private String getAIStr(ArtifactReadable action) {
        StringBuilder sb = new StringBuilder();
        ArtifactReadable teamWf = ActionPage.getParentTeamWf(action);
        if (teamWf != null && teamWf.isValid()) {
            List artifactIds = teamWf.getAttributeValues((AttributeTypeToken)AtsAttributeTypes.ActionableItemReference);
            for (ArtifactId artifactId : artifactIds) {
                sb.append(this.atsApi.getQueryService().getArtifact(artifactId));
                sb.append(", ");
            }
        }
        return sb.toString().replaceFirst(", $", "");
    }

    public static String getCreatedByStr(IAtsWorkItem workItem, ArtifactReadable action) {
        String results = action.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CreatedBy);
        results = workItem.getCreatedBy().getName();
        return results;
    }

    public void addTransitionStates(ViewModel page) {
        try {
            IAtsWorkItem workItem = this.getWorkItem();
            String html = OseeInf.getResourceContents((String)"templates/transition.html", this.getClass());
            html = html.replaceAll("PUT_POST_URL_HERE", "/ats/action/state");
            html = html.replaceAll("PUT_ATS_ID_HERE", workItem.getAtsId());
            html = html.replaceFirst("PUT_TO_STATE_LIST_HERE", this.getToStateList());
            String defaultToStateValue = "";
            StateDefinition defaultToState = this.atsApi.getWorkItemService().getDefaultToState(workItem);
            if (defaultToState != null) {
                defaultToStateValue = "value=\"" + defaultToState.getName() + "\"";
            }
            html = html.replaceAll("PUT_DEFAULT_TO_STATE_VALUE_HERE", defaultToStateValue);
            page.param("transition", (Object)html);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private String getToStateList() {
        StringBuilder sb = new StringBuilder("<datalist id=\"ToStateList\">\n");
        for (StateDefinition state : this.atsApi.getWorkItemService().getAllToStates(this.workItem)) {
            sb.append("<option value=\"");
            sb.append(state.getName());
            sb.append("\" id=\"");
            sb.append(state.getName());
            sb.append("\">\n");
        }
        sb.append("</datalist>");
        return sb.toString();
    }

    private String getVersion(IAtsWorkItem workItem) {
        String version = "<on full load>";
        try {
            IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
            String str = this.atsApi.getWorkItemService().getTargetedVersionStr(teamWf);
            if (Strings.isValid((String)str)) {
                version = str;
            }
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error getting version for [%s]", new Object[]{workItem});
            version = "exception: " + ex.getLocalizedMessage();
        }
        return version;
    }

    private void addStates(ViewModel page, IAtsWorkItem workItem, ArtifactReadable action) throws Exception {
        StringBuilder statesSb = new StringBuilder();
        WorkDefinition workDefinition = workItem.getWorkDefinition();
        IAtsStateManager stateMgr = workItem.getStateMgr();
        List visitedStates = stateMgr.getVisitedStateNames();
        List statesOrderedByOrdinal = this.atsApi.getWorkDefinitionService().getStatesOrderedByOrdinal(workDefinition);
        int index = statesOrderedByOrdinal.size() - 1;
        while (index >= 0) {
            StateDefinition state = (StateDefinition)statesOrderedByOrdinal.get(index);
            if (visitedStates.contains(state.getName())) {
                String stateHtmlTemplate = this.getStateHtmlTemplate();
                String stateName = state.getName();
                if (stateName.equals(this.atsApi.getWorkItemService().getCurrentStateName(workItem))) {
                    stateName = String.format("CURRENT STATE => <b>%s</b>", stateName);
                    if (workItem.getCurrentStateType().isCompleted()) {
                        stateName = String.format("%s - on <b>%s</b> - by <b>%s</b>", stateName, DateUtil.getMMDDYYHHMM((Date)workItem.getCompletedDate()), workItem.getCompletedBy().getName());
                    } else if (workItem.getCurrentStateType().isCancelled()) {
                        stateName = String.format("%s - on <b>%s</b> - by <b>%s</b><br/>from <b>%s</b> - reason <b>[%s]</b>", stateName, DateUtil.getMMDDYYHHMM((Date)workItem.getCancelledDate()), workItem.getCancelledBy().getName(), workItem.getCancelledFromState(), workItem.getCancelledReason());
                    }
                }
                stateHtmlTemplate = stateHtmlTemplate.replace("TITLE", stateName);
                StringBuilder widgets = new StringBuilder();
                this.addWidgets(widgets, workItem, state.getLayoutItems());
                stateHtmlTemplate = stateHtmlTemplate.replace("WIDGETS", widgets.toString());
                statesSb.append(stateHtmlTemplate);
            }
            --index;
        }
        page.param("states", (Object)statesSb.toString());
    }

    private void addWidgets(StringBuilder sb, IAtsWorkItem workItem, Collection<LayoutItem> items) {
        this.addLayoutItems(sb, workItem, items);
    }

    private void addLayoutItems(StringBuilder sb, IAtsWorkItem workItem, Collection<LayoutItem> items) {
        for (LayoutItem layout : items) {
            if (layout instanceof CompositeLayoutItem) {
                this.inComposite = true;
                sb.append("<tr><td><table width=\"100%\"><tr>");
                this.addWidgets(sb, workItem, ((CompositeLayoutItem)layout).getLayoutItems());
                sb.append("</tr></table></td></tr>");
                this.inComposite = false;
                continue;
            }
            WidgetDefinition widget = (WidgetDefinition)layout;
            if (this.getIgnoreWidgetNames().contains(widget.getName())) continue;
            if (!this.inComposite) {
                sb.append("<tr><td>");
            } else {
                sb.append("<td>");
            }
            this.addWidget(sb, workItem, widget);
            if (!this.inComposite) {
                sb.append("</td></tr>");
                continue;
            }
            sb.append("</td>");
        }
    }

    private void addWidget(StringBuilder sb, IAtsWorkItem workItem, WidgetDefinition widget) {
        if (widget.getName().equals(ROLE_WIDGET_NAME)) {
            this.addRoleWidget(sb, workItem, widget);
        } else if (widget.getName().equals(REVIEW_DEFECT_WIDGET_NAME)) {
            this.addDefectWidget(sb, workItem, widget);
        } else if (widget.getName().equals(COMMIT_MANAGER_WIDGET_NAME)) {
            this.addCommitManager(sb, workItem, widget);
        } else {
            this.addWidgetDefault(sb, workItem, widget);
        }
    }

    private void addCommitManager(StringBuilder sb, IAtsWorkItem workItem2, WidgetDefinition widget) {
        sb.append("Commit Manager: ");
        BranchToken branch = this.atsApi.getBranchService().getBranch((IAtsTeamWorkflow)this.workItem);
        if (branch.isValid()) {
            sb.append(branch.getName());
        }
    }

    private List<String> getIgnoreWidgetNames() {
        if (ignoredWidgets == null) {
            ignoredWidgets = new ArrayList<String>();
            String configValue = this.atsApi.getConfigValue("IgnoredWidgetNames");
            if (Strings.isValid((String)configValue)) {
                String[] stringArray = configValue.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String widgetName = stringArray[n2];
                    ignoredWidgets.add(widgetName);
                    ++n2;
                }
            }
        }
        return ignoredWidgets;
    }

    private void addRoleWidget(StringBuilder sb, IAtsWorkItem workItem, WidgetDefinition widget) {
        sb.append("Roles: ");
        List roles = this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.Role);
        if (!roles.isEmpty()) {
            sb.append(ROLE_TABLE_HEADER);
            for (String xml : roles) {
                sb.append("<tr>");
                for (String key : roleKeys) {
                    sb.append("<td>");
                    String data = AXml.getTagData((String)xml, (String)key);
                    if (key.equals("userId")) {
                        data = this.atsApi.getUserService().getUserByUserId(data).getName();
                    }
                    sb.append(data);
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
        }
    }

    private void addDefectWidget(StringBuilder sb, IAtsWorkItem workItem, WidgetDefinition widget) {
        sb.append("Defects: ");
        List defects = this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ReviewDefect);
        if (!defects.isEmpty()) {
            sb.append(DEFECT_TABLE_HEADER);
            for (String xml : defects) {
                sb.append("<tr>");
                for (String key : defectKeys) {
                    sb.append("<td>");
                    String data = AXml.getTagData((String)xml, (String)key);
                    if (key.equals("user")) {
                        data = this.atsApi.getUserService().getUserByUserId(data).getName();
                    } else if (key.equals("date")) {
                        data = DateUtil.getDateStr((Date)new Date(Long.valueOf(data)), (String)"MM/dd/yyyy hh:mm a");
                    }
                    sb.append(data);
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
        }
    }

    private void addWidgetDefault(StringBuilder sb, IAtsWorkItem workItem, WidgetDefinition widget) {
        sb.append(widget.getName());
        try {
            AttributeTypeToken attrType = widget.getAttributeType();
            if (attrType != null) {
                sb.append(": <b>");
                List attributesToStringList = this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, attrType);
                if (attributesToStringList.size() > 1) {
                    sb.append(attributesToStringList.toString());
                } else if (attributesToStringList.size() == 1) {
                    sb.append(AHTML.textToHtml((String)String.valueOf(attributesToStringList.iterator().next())));
                }
                sb.append("</b>");
            }
        }
        catch (OseeCoreException ex) {
            sb.append("exception: " + ex.getLocalizedMessage());
        }
    }

    private String getStateHtmlTemplate() throws Exception {
        if (this.pageTemplate == null) {
            this.pageTemplate = OseeInf.getResourceContents((String)"templates/state.html", this.getClass());
        }
        return this.pageTemplate;
    }

    private void addDetails(ViewModel page, IAtsWorkItem workItem, ArtifactReadable artifact) {
        StringBuilder sb = new StringBuilder();
        if (this.details) {
            try {
                ActionPage.addDetail(sb, "Artifact Type", artifact.getArtifactType().getName());
                sb.append("</br><b>Attribute Raw Data:</b></br>");
                for (AttributeReadable attr : artifact.getAttributes()) {
                    ActionPage.addDetail(sb, attr.getAttributeType().getName(), AHTML.textToHtml((String)String.valueOf(attr.getValue())));
                }
            }
            catch (OseeCoreException ex) {
                sb.append("exception: " + ex.getLocalizedMessage());
            }
        }
        page.param("details", (Object)sb.toString());
    }

    private static void addDetail(StringBuilder sb, String key, String value) {
        sb.append(key);
        sb.append(": <b>");
        sb.append(value);
        sb.append("</b></br>");
    }

    public boolean isAddTransition() {
        return this.addTransition;
    }

    public void setAddTransition(boolean addTransition) {
        this.addTransition = addTransition;
    }
}

