/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class ReservedCharacters {
    private static Map<String, Character> reservedCharacters = new HashMap<String, Character>();
    private static Map<Character, String> charsToEncoding = new HashMap<Character, String>();
    private static Map<Character, String> xmlEntitiesMap = new HashMap<Character, String>();

    static {
        try {
            ReservedCharacters.loadReservedChars();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        xmlEntitiesMap.put(Character.valueOf('\"'), "&quot;");
        xmlEntitiesMap.put(Character.valueOf('\''), "&apos;");
        xmlEntitiesMap.put(Character.valueOf('&'), "&amp;");
        xmlEntitiesMap.put(Character.valueOf('<'), "&lt;");
        xmlEntitiesMap.put(Character.valueOf('>'), "&gt;");
        for (Map.Entry<String, Character> entry : reservedCharacters.entrySet()) {
            charsToEncoding.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : xmlEntitiesMap.entrySet()) {
            charsToEncoding.put((Character)entry.getKey(), (String)entry.getValue());
            reservedCharacters.put((String)entry.getValue(), (Character)entry.getKey());
        }
    }

    private static void loadReservedChars() throws UnsupportedEncodingException, IOException {
        BufferedReader reader = null;
        try {
            URL url = ReservedCharacters.class.getResource("ReservedCharacters.txt");
            reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] items = line.split(",\\s*");
                String key = items[0];
                String value = items[1];
                Character charValue = Character.valueOf(value.charAt(1));
                reservedCharacters.put(key, charValue);
            }
        }
        catch (Throwable throwable) {
            Lib.close(reader);
            throw throwable;
        }
        Lib.close(reader);
    }

    private ReservedCharacters() {
    }

    public static String encode(String original) {
        return ReservedCharacters.encode(original, charsToEncoding);
    }

    public static String encodeXmlEntities(String original) {
        return ReservedCharacters.encode(original, xmlEntitiesMap);
    }

    private static String encode(String original, Map<Character, String> charactersToEntityMap) {
        StringBuilder encodedItem = new StringBuilder();
        int index = 0;
        while (index < original.length()) {
            char item = original.charAt(index);
            String encode = charactersToEntityMap.get(Character.valueOf(item));
            if (encode != null) {
                encodedItem.append(encode);
            } else {
                encodedItem.append(item);
            }
            ++index;
        }
        return encodedItem.toString();
    }

    public static Character toCharacter(String entity) {
        Character character = null;
        if (Strings.isValid(entity)) {
            entity = entity.trim();
            character = reservedCharacters.get(entity);
        }
        return character;
    }

    public static Collection<Character> getChars() {
        return reservedCharacters.values();
    }
}

