/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.util;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.db.internal.IdentityManager;

public class IdentityManagerImpl
implements IdentityManager {
    private final JdbcClient client;
    public static boolean USE_LONG_IDS = ArtifactToken.USE_LONG_IDS;

    public IdentityManagerImpl(JdbcClient client) {
        this.client = client;
    }

    @Override
    public TransactionId getNextTransactionId() {
        return TransactionId.valueOf((Long)this.client.getNextSequence("SKYNET_TRANSACTION_ID_SEQ", false));
    }

    @Override
    public ArtifactId getNextArtifactId() {
        if (USE_LONG_IDS) {
            return ArtifactId.valueOf((Long)Lib.generateUuid());
        }
        return ArtifactId.valueOf((Long)this.client.getNextSequence("SKYNET_ART_ID_SEQ", true));
    }

    @Override
    public AttributeId getNextAttributeId() {
        if (USE_LONG_IDS) {
            return AttributeId.valueOf((Long)Lib.generateUuid());
        }
        return AttributeId.valueOf((Long)this.client.getNextSequence("SKYNET_ATTR_ID_SEQ", true));
    }

    @Override
    public RelationId getNextRelationId() {
        if (USE_LONG_IDS) {
            return RelationId.valueOf((Long)Lib.generateUuid());
        }
        return RelationId.valueOf((Long)this.client.getNextSequence("SKYNET_REL_LINK_ID_SEQ", true));
    }

    @Override
    public GammaId getNextGammaId() {
        if (USE_LONG_IDS) {
            return GammaId.valueOf((Long)Lib.generateUuid());
        }
        return GammaId.valueOf((Long)this.client.getNextSequence("SKYNET_GAMMA_ID_SEQ", true));
    }

    @Override
    public String getUniqueGuid(String guid) {
        String toReturn = guid;
        if (toReturn == null) {
            toReturn = GUID.create();
        }
        return toReturn;
    }
}

