/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.ds.BinaryDataProxy;
import org.eclipse.osee.orcs.core.ds.CharacterDataProxy;
import org.eclipse.osee.orcs.core.ds.ResourceNameResolver;
import org.eclipse.osee.orcs.db.internal.proxy.AbstractDataProxy;

public class UriDataProxy
extends AbstractDataProxy
implements CharacterDataProxy,
BinaryDataProxy {
    private String displayable = "";

    public Object getRawValue() {
        return "";
    }

    public String getDisplayableString() {
        return this.displayable;
    }

    public void setDisplayableString(String toDisplay) {
        this.displayable = toDisplay;
    }

    public boolean setValue(ByteBuffer data) {
        boolean response = false;
        try {
            ByteBuffer original = this.getValueAsBytes();
            if (original != null && data == null || original == null && data != null || original != null && !original.equals(data)) {
                if (data != null) {
                    ResourceNameResolver resolver = this.getResolver();
                    Conditions.checkNotNull((Object)resolver, (String)"ResourceNameResolver", (String)"Unable to determine internal file name", (Object[])new Object[0]);
                    byte[] compressed = Lib.compressStream((InputStream)Lib.byteBufferToInputStream((ByteBuffer)data), (String)resolver.getInternalFileName());
                    this.getStorage().setContent(compressed, "zip", "application/zip", "ISO-8859-1");
                } else {
                    this.getStorage().setContent(null, "txt", "txt/plain", "UTF-8");
                }
                response = true;
            }
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return response;
    }

    public ByteBuffer getValueAsBytes() {
        ByteBuffer decompressed = null;
        byte[] rawData = this.getStorage().getContent();
        if (rawData != null) {
            try {
                decompressed = ByteBuffer.wrap(Lib.decompressBytes((InputStream)new ByteArrayInputStream(rawData)));
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        return decompressed;
    }

    public String getValueAsString() {
        String toReturn = null;
        ByteBuffer data = this.getValueAsBytes();
        if (data != null) {
            try {
                toReturn = new String(data.array(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        } else {
            toReturn = "";
        }
        return toReturn;
    }

    public boolean setValue(Object value) {
        ByteBuffer toSet = null;
        if (value != null && value instanceof String) {
            try {
                toSet = ByteBuffer.wrap(((String)value).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        } else if (value != null) {
            OseeCoreException.wrapAndThrow((Throwable)new UnsupportedEncodingException(String.format("Unsupported type [%s]", value.getClass().toGenericString())));
        }
        return this.setValue(toSet);
    }

    public void setData(Object value, String uri) {
        this.getStorage().setLocator(uri);
    }

    public Object getValue() {
        return this.getValueAsString();
    }

    public String getStorageString() {
        return "";
    }
}

