/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.processor;

import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.db.internal.loader.data.AttributeObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.processor.LoadProcessor;

public class AttributeLoadProcessor
extends LoadProcessor<AttributeData, AttributeObjectFactory> {
    private final Log logger;
    private final OrcsTokenService tokenService;

    public AttributeLoadProcessor(Log logger, AttributeObjectFactory factory, OrcsTokenService tokenService) {
        super(factory);
        this.logger = logger;
        this.tokenService = tokenService;
    }

    @Override
    protected AttributeData createData(Object conditions, AttributeObjectFactory factory, JdbcStatement chStmt, Options options) {
        AttributeData<Object> toReturn = null;
        BranchId branch = BranchId.create((Long)chStmt.getLong("branch_id"), (ArtifactId)OptionsUtil.getFromBranchView((Options)options));
        ArtifactId artId = ArtifactId.valueOf((Long)chStmt.getLong("id2"));
        AttributeId attrId = AttributeId.valueOf((Long)chStmt.getLong("attr_id"));
        GammaId gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
        ModificationType modType = ModificationType.valueOf((long)chStmt.getInt("mod_type"));
        ApplicabilityId applicId = ApplicabilityId.valueOf((Long)chStmt.getLong("app_id"));
        boolean historical = OptionsUtil.isHistorical((Options)options);
        CreateConditions condition = this.asConditions(conditions);
        if (!condition.isSame(branch, artId, attrId)) {
            condition.saveConditions(branch, artId, attrId, gammaId, modType);
            TransactionId txId = TransactionId.valueOf((Long)chStmt.getLong("transaction_id"));
            VersionData version = factory.createVersion(branch, txId, gammaId, historical);
            if (historical) {
                version.setStripeId(TransactionId.valueOf((Long)chStmt.getLong("stripe_transaction_id")));
            }
            AttributeTypeGeneric attributeType = this.tokenService.getAttributeTypeOrCreate(Long.valueOf(chStmt.getLong("attr_type_id")));
            Object value = chStmt.loadAttributeValue((AttributeTypeToken)attributeType);
            String uri = chStmt.getString("uri");
            toReturn = factory.createAttributeData(version, attrId, attributeType, modType, artId, value, uri, applicId);
        } else if (!historical) {
            this.logger.warn("multiple attribute versions for attribute id [%s] artifact id[%s] branch[%s] previousGammaId[%s] currentGammaId[%s] previousModType[%s] currentModType[%s]", new Object[]{attrId, artId, branch, condition.previousGammaId, gammaId, condition.previousModType, modType});
        }
        return toReturn;
    }

    @Override
    protected Object createPreConditions(Options options) {
        return new CreateConditions();
    }

    private CreateConditions asConditions(Object conditions) {
        return (CreateConditions)conditions;
    }

    private static final class CreateConditions {
        ArtifactId previousArtId = ArtifactId.SENTINEL;
        BranchId previousBranchId = BranchId.SENTINEL;
        AttributeId previousAttrId = AttributeId.SENTINEL;
        GammaId previousGammaId = GammaId.SENTINEL;
        ModificationType previousModType = null;

        private CreateConditions() {
        }

        boolean isSame(BranchId branch, ArtifactId artifactId, AttributeId attrId) {
            return this.previousBranchId.equals(branch) && this.previousArtId.equals(artifactId) && this.previousAttrId.equals(attrId);
        }

        void saveConditions(BranchId branch, ArtifactId artifactId, AttributeId attrId, GammaId gammaId, ModificationType modType) {
            this.previousBranchId = branch;
            this.previousArtId = artifactId;
            this.previousAttrId = attrId;
            this.previousGammaId = gammaId;
            this.previousModType = modType;
        }
    }
}

