/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.executor.ExecutionCallback;
import org.eclipse.osee.framework.core.executor.ExecutionCallbackAdapter;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.ExportOptions;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.SystemProperties;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.exchange.ExchangeUtil;
import org.eclipse.osee.orcs.db.internal.exchange.ExportItemFactory;
import org.eclipse.osee.orcs.db.internal.exchange.export.AbstractExportItem;
import org.eclipse.osee.orcs.db.internal.resource.ResourceConstants;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class ExportBranchDatabaseCallable
extends AbstractDatastoreCallable<URI> {
    private static final String BRANCH_EXPORT_EXECUTOR_ID = "branch.export.worker";
    private final ExportItemFactory factory;
    private final SqlJoinFactory joinFactory;
    private final SystemProperties properties;
    private final ExecutorAdmin executorAdmin;
    private final List<? extends BranchId> branches;
    private final PropertyStore options;
    private String exportName;

    public ExportBranchDatabaseCallable(OrcsSession session, ExportItemFactory factory, SqlJoinFactory joinFactory, SystemProperties properties, ExecutorAdmin executorAdmin, List<? extends BranchId> branches, PropertyStore options, String exportName) {
        super(factory.getLogger(), session, factory.getDbService());
        this.joinFactory = joinFactory;
        this.factory = factory;
        this.properties = properties;
        this.executorAdmin = executorAdmin;
        this.branches = branches;
        this.options = options;
        this.exportName = exportName;
    }

    private ExecutorAdmin getExecutorAdmin() {
        return this.executorAdmin;
    }

    private String getExchangeFileName() {
        return this.exportName;
    }

    private void setExchangeFileName(String name) {
        this.exportName = name;
    }

    public URI call() throws Exception {
        URI uRI;
        long startTime = System.currentTimeMillis();
        try {
            Conditions.checkNotNull((Object)this.factory, (String)"exportItemFactory");
            Conditions.checkNotNull((Object)this.executorAdmin, (String)"executorAdmin");
            Conditions.checkNotNullOrEmpty(this.branches, (String)"branches");
            Conditions.checkNotNull((Object)this.options, (String)"options");
            this.doWork();
            uRI = this.factory.getResourceManager().generateResourceLocator("exchange", "", this.getExchangeFileName()).getLocation();
        }
        catch (Throwable throwable) {
            this.getLogger().info("Exported [%s] branch%s in [%s]", new Object[]{this.branches.size(), this.branches.size() != 1 ? "es" : "", Lib.getElapseString((long)startTime)});
            throw throwable;
        }
        this.getLogger().info("Exported [%s] branch%s in [%s]", new Object[]{this.branches.size(), this.branches.size() != 1 ? "es" : "", Lib.getElapseString((long)startTime)});
        return uRI;
    }

    private File createTempFolder() {
        String exchangeBasePath = ResourceConstants.getExchangeDataPath(this.properties);
        File rootDirectory = ExchangeUtil.createTempFolder(exchangeBasePath);
        if (!Strings.isValid((String)this.getExchangeFileName())) {
            this.setExchangeFileName(rootDirectory.getName());
        }
        return rootDirectory;
    }

    private void doWork() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IdJoinQuery joinQuery = this.joinFactory.createIdJoinQuery();){
            joinQuery.addAndStore(this.branches);
            List<AbstractExportItem> taskList = this.factory.createTaskList((long)joinQuery.getQueryId(), this.options);
            File tempFolder = this.createTempFolder();
            for (AbstractExportItem exportItem : taskList) {
                exportItem.setWriteLocation(tempFolder);
            }
            this.executeTasks(taskList);
            this.finishExport(tempFolder);
            for (AbstractExportItem exportItem : taskList) {
                exportItem.cleanUp();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void finishExport(File tempFolder) throws IllegalArgumentException, IOException {
        String zipTargetName = String.valueOf(this.getExchangeFileName()) + "." + "zip";
        if (this.options.getBoolean(ExportOptions.COMPRESS.name())) {
            this.getLogger().info("Compressing Branch Export Data - [%s]", new Object[]{zipTargetName});
            File zipTarget = new File(tempFolder.getParent(), zipTargetName);
            Lib.compressDirectory((File)tempFolder, (String)zipTarget.getAbsolutePath(), (boolean)true);
            this.getLogger().info("Deleting Branch Export Temp Folder - [%s]", new Object[]{tempFolder});
            Lib.deleteDir((File)tempFolder);
        } else {
            File target = new File(tempFolder.getParent(), this.getExchangeFileName());
            if (!target.equals(tempFolder) && !tempFolder.renameTo(target)) {
                this.getLogger().info("Unable to move [%s] to [%s]", new Object[]{tempFolder.getAbsolutePath(), target.getAbsolutePath()});
            }
        }
    }

    private void executeTasks(List<AbstractExportItem> taskList) throws Exception {
        final LinkedList throwables = new LinkedList();
        final CopyOnWriteArrayList<Future> futures = new CopyOnWriteArrayList<Future>();
        ExecutorAdmin executor = this.getExecutorAdmin();
        for (AbstractExportItem exportItem : taskList) {
            Future future = executor.schedule(BRANCH_EXPORT_EXECUTOR_ID, (Callable)((Object)exportItem), (ExecutionCallback)new ExecutionCallbackAdapter<Boolean>(){

                public void onFailure(Throwable throwable) {
                    super.onFailure(throwable);
                    throwables.add(throwable);
                    for (Future future : futures) {
                        if (future.isDone() || future.isCancelled()) continue;
                        future.cancel(true);
                    }
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        if (!throwables.isEmpty()) {
            LinkedList<StackTraceElement> trace = new LinkedList<StackTraceElement>();
            for (Throwable th : throwables) {
                StackTraceElement[] stackTraceElementArray = th.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    trace.add(element);
                    ++n2;
                }
            }
            OseeCoreException exception = new OseeCoreException("Error detected during branch export", new Object[0]);
            exception.setStackTrace(trace.toArray(new StackTraceElement[trace.size()]));
            throw exception;
        }
    }
}

