/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.transition;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public abstract class TransitionHelperAdapter
implements ITransitionHelper {
    protected AtsApi atsApi;
    protected final TransitionData transData;

    public TransitionHelperAdapter(AtsApi atsApi) {
        this.atsApi = atsApi;
        this.transData = new TransitionData();
    }

    public TransitionHelperAdapter(AtsApi atsApi, TransitionData transData) {
        this.atsApi = atsApi;
        this.transData = transData;
    }

    public boolean isOverrideTransitionValidityCheck() {
        return false;
    }

    public boolean isReload() {
        return true;
    }

    public boolean isOverrideAssigneeCheck() {
        return false;
    }

    public boolean isOverrideWorkingBranchCheck() {
        return false;
    }

    public boolean isWorkingBranchInWork(IAtsTeamWorkflow teamWf) {
        return this.atsApi.getBranchService().isWorkingBranchInWork(teamWf);
    }

    public boolean isBranchInCommit(IAtsTeamWorkflow teamWf) {
        return this.atsApi.getBranchService().isBranchInCommit(teamWf);
    }

    public boolean isSystemUser() {
        return AtsCoreUsers.isAtsCoreUser((AtsUser)this.getTransitionUser());
    }

    public boolean isExecuteChanges() {
        return false;
    }

    public AtsUser getTransitionUser() {
        AtsUser user = this.transData.getTransitionUser();
        if (user == null) {
            user = this.atsApi.getUserService().getCurrentUser();
        }
        return user;
    }

    public void setTransitionUser(AtsUser user) {
        this.transData.setTransitionUser(user);
    }

    public abstract Collection<IAtsWorkItem> getWorkItems();

    public void handleWorkflowReload(TransitionResults results) {
        if (!this.transData.isWorkflowsReloaded()) {
            LinkedList<IAtsWorkItem> workItemsToReload = new LinkedList<IAtsWorkItem>();
            for (IAtsWorkItem workItem : this.getWorkItems()) {
                boolean changed = this.atsApi.getStoreService().isChangedInDb(workItem);
                if (!changed) continue;
                workItemsToReload.add(workItem);
            }
            if (!workItemsToReload.isEmpty()) {
                this.atsApi.getStoreService().reload(workItemsToReload);
            }
            for (IAtsWorkItem workItem : this.getWorkItems()) {
                if (!this.atsApi.getStoreService().isDeleted((IAtsObject)workItem)) continue;
                results.addResult(workItem, TransitionResult.WORKITEM_DELETED);
            }
            this.transData.setWorkflowsReloaded(true);
        }
    }

    public TransitionData getTransData() {
        return this.transData;
    }

    public void setAtsApi(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public AtsApi getServices() {
        return this.atsApi;
    }

    public AttributeTypeToken getCancellationReasonAttrType() {
        return AtsAttributeTypes.CancelledReason;
    }
}

