/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef.builder;

import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.StateEventType;
import org.eclipse.osee.ats.api.workdef.StateToken;
import org.eclipse.osee.ats.api.workdef.model.PeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;

public class PeerReviewDefinitionBuilder {
    PeerReviewDefinition peerRev = new PeerReviewDefinition();

    public PeerReviewDefinitionBuilder(String name) {
        this.peerRev.setName(name);
    }

    public PeerReviewDefinitionBuilder andTitle(String title) {
        this.peerRev.setReviewTitle(title);
        return this;
    }

    public PeerReviewDefinitionBuilder andDescription(String description) {
        this.peerRev.setDescription(description);
        return this;
    }

    public PeerReviewDefinitionBuilder andRelatedToState(StateToken state) {
        this.peerRev.setRelatedToState(state.getName());
        return this;
    }

    public PeerReviewDefinitionBuilder andBlockingType(ReviewBlockType reviewBlockType) {
        this.peerRev.setBlockingType(reviewBlockType);
        return this;
    }

    public PeerReviewDefinitionBuilder andEvent(StateEventType stateEventType) {
        this.peerRev.setStateEventType(stateEventType);
        return this;
    }

    public PeerReviewDefinitionBuilder andAssignees(AtsUser ... assignees) {
        AtsUser[] atsUserArray = assignees;
        int n = assignees.length;
        int n2 = 0;
        while (n2 < n) {
            AtsUser assignee = atsUserArray[n2];
            this.peerRev.addAssignee(assignee);
            ++n2;
        }
        return this;
    }

    public PeerReviewDefinition getReviewDefinition() {
        return this.peerRev;
    }
}

