/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueService;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.model.WorkPackage;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;

public abstract class AtsAbstractEarnedValueImpl
implements IAtsEarnedValueService {
    protected final Log logger;
    protected final AtsApi atsApi;

    public AtsAbstractEarnedValueImpl(Log logger, AtsApi atsApi) {
        this.logger = logger;
        this.atsApi = atsApi;
    }

    public IAtsWorkPackage getWorkPackageById(ArtifactId workPackageId) {
        IAtsWorkPackage workPackage = null;
        if (workPackageId instanceof IAtsWorkPackage) {
            workPackage = (IAtsWorkPackage)workPackageId;
        } else {
            ArtifactToken art = this.atsApi.getQueryService().getArtifact(workPackageId);
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.WorkPackage})) {
                workPackage = new WorkPackage(this.atsApi.getLogger(), this.atsApi, art);
            }
        }
        return workPackage;
    }

    public ArtifactId getWorkPackageId(IAtsWorkItem workItem) {
        ArtifactToken artifact = this.atsApi.getQueryService().getArtifact((IAtsObject)workItem);
        Conditions.checkNotNull((Object)artifact, (String)"workItem", (String)"Can't Find Work Package matching %s", (Object[])new Object[]{workItem.toStringWithId()});
        return (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)artifact, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, (Object)ArtifactId.SENTINEL);
    }

    public IAtsWorkPackage getWorkPackage(IAtsWorkItem workItem) {
        ArtifactId workPackageId = this.getWorkPackageId(workItem);
        if (workPackageId.isValid()) {
            ArtifactToken workPkgArt = this.atsApi.getQueryService().getArtifact(workPackageId);
            return new WorkPackage(this.logger, this.atsApi, workPkgArt);
        }
        return null;
    }

    public Collection<IAtsWorkPackage> getWorkPackageOptions(IAtsObject object) {
        ArrayList<IAtsWorkPackage> workPackageOptions = new ArrayList<IAtsWorkPackage>();
        this.getWorkPackageOptions(object, workPackageOptions);
        return workPackageOptions;
    }

    public Collection<IAtsWorkPackage> getWorkPackageOptions(IAtsObject object, List<IAtsWorkPackage> workPackageOptions) {
        block10: {
            block9: {
                if (!(object instanceof IAtsConfigObject)) break block9;
                IAtsConfigObject configObj = (IAtsConfigObject)object;
                ArtifactToken artifact = this.atsApi.getQueryService().getArtifact((IAtsObject)configObj);
                if (artifact == null) break block10;
                for (ArtifactToken workPackageArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)artifact, AtsRelationTypes.TeamDefinitionToWorkPackage_WorkPackage)) {
                    workPackageOptions.add(new WorkPackage(this.logger, this.atsApi, workPackageArt));
                }
                break block10;
            }
            if (object instanceof IAtsTeamWorkflow) {
                IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)object;
                this.getWorkPackageOptions((IAtsObject)teamWf.getTeamDefinition(), workPackageOptions);
                for (IAtsActionableItem ai : teamWf.getActionableItems()) {
                    this.getWorkPackageOptions((IAtsObject)ai, workPackageOptions);
                }
            } else if (object instanceof IAtsWorkItem) {
                IAtsWorkItem workItem = (IAtsWorkItem)object;
                IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
                if (teamWf != null) {
                    this.getWorkPackageOptions((IAtsObject)teamWf, workPackageOptions);
                } else if (workItem instanceof IAtsAbstractReview) {
                    IAtsAbstractReview review = (IAtsAbstractReview)workItem;
                    for (IAtsActionableItem ai : review.getActionableItems()) {
                        this.getWorkPackageOptions((IAtsObject)ai, workPackageOptions);
                        if (ai.getTeamDefinition() == null) continue;
                        this.getWorkPackageOptions((IAtsObject)ai.getTeamDefinition(), workPackageOptions);
                    }
                }
            }
        }
        return workPackageOptions;
    }

    public IAtsWorkPackage getWorkPackage(ArtifactId artifact) {
        ArtifactToken realArt = this.atsApi.getQueryService().getArtifact(artifact);
        return new WorkPackage(this.logger, this.atsApi, realArt);
    }

    public Collection<IAtsWorkPackage> getWorkPackages(IAtsInsertionActivity insertionActivity) {
        ArrayList<IAtsWorkPackage> workPackages = new ArrayList<IAtsWorkPackage>();
        for (ArtifactToken artifact : this.atsApi.getRelationResolver().getRelated((ArtifactId)this.atsApi.getQueryService().getArtifact(insertionActivity.getId()), AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage)) {
            workPackages.add(new WorkPackage(this.logger, this.atsApi, artifact));
        }
        return workPackages;
    }

    public double getEstimatedHoursFromArtifact(IAtsWorkItem workItem) {
        return (Double)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.EstimatedHours, (Object)0.0);
    }

    public double getEstimatedHoursFromTasks(IAtsWorkItem workItem) {
        if (!(workItem instanceof IAtsTeamWorkflow)) {
            return 0.0;
        }
        double hours = 0.0;
        for (IAtsTask task : this.atsApi.getTaskService().getTask(workItem)) {
            hours += this.getEstimatedHoursFromArtifact((IAtsWorkItem)task);
        }
        return hours;
    }

    public double getEstimatedHoursFromReviews(IAtsWorkItem workItem) {
        double hours = 0.0;
        if (workItem.isTeamWorkflow()) {
            for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews((IAtsTeamWorkflow)workItem)) {
                hours += this.getEstimatedHoursFromArtifact((IAtsWorkItem)review);
            }
        }
        return hours;
    }

    public double getEstimatedHoursFromReviews(IAtsWorkItem workItem, IStateToken relatedToState) {
        double hours = 0.0;
        if (workItem.isTeamWorkflow()) {
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
            for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews(teamWf)) {
                if (!review.getRelatedToState().equals(relatedToState.getName())) continue;
                hours += this.getEstimatedHoursFromArtifact((IAtsWorkItem)review);
            }
        }
        return hours;
    }

    public double getEstimatedHoursTotal(IAtsWorkItem workItem) {
        return this.getEstimatedHoursFromArtifact(workItem) + this.getEstimatedHoursFromTasks(workItem) + this.getEstimatedHoursFromReviews(workItem);
    }

    public void setWorkPackage(IAtsWorkPackage workPackage, IAtsWorkItem workItem, IAtsChangeSet changes) {
        changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, (Object)workPackage.getArtifactId());
    }

    public double getRemainHoursFromArtifact(IAtsWorkItem workItem) {
        if (workItem.isCompletedOrCancelled()) {
            return 0.0;
        }
        double est = (Double)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.EstimatedHours, (Object)0.0);
        if (est == 0.0) {
            return this.getEstimatedHoursFromArtifact(workItem);
        }
        return est - est * (double)this.atsApi.getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)workItem) / 100.0;
    }

    public double getRemainHoursTotal(IAtsWorkItem workItem) {
        return this.getRemainHoursFromArtifact(workItem) + this.getRemainFromTasks(workItem) + this.getRemainFromReviews(workItem);
    }

    public double getRemainFromTasks(IAtsWorkItem workItem) {
        if (!workItem.isTeamWorkflow()) {
            return 0.0;
        }
        double hours = 0.0;
        for (IAtsTask task : this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)workItem)) {
            hours += this.getRemainHoursFromArtifact((IAtsWorkItem)task);
        }
        return hours;
    }

    public double getRemainFromReviews(IAtsWorkItem workItem) {
        if (workItem.isTeamWorkflow()) {
            return this.atsApi.getEarnedValueService().getEstimatedHoursFromReviews(workItem);
        }
        return 0.0;
    }

    public double getManHrsPerDayPreference() {
        return 8.0;
    }

    public int getPercentCompleteFromTasks(IAtsWorkItem workItem, IStateToken relatedToState) {
        int spent = 0;
        int result = 0;
        if (workItem.isTeamWorkflow()) {
            Collection tasks = this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)workItem, relatedToState);
            for (IAtsTask task : tasks) {
                spent += this.atsApi.getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)task);
            }
            if (spent > 0) {
                result = spent / tasks.size();
            }
        }
        return result;
    }

    public int getPercentCompleteFromTasks(IAtsWorkItem workItem) {
        int spent = 0;
        int result = 0;
        if (workItem.isTeamWorkflow()) {
            Collection tasks = this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)workItem);
            for (IAtsTask task : tasks) {
                spent += this.atsApi.getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)task);
            }
            if (spent > 0) {
                result = spent / tasks.size();
            }
        }
        return result;
    }

    public int getPercentCompleteFromReviews(IAtsWorkItem workItem, IStateToken relatedToState) {
        int spent = 0;
        if (workItem.isTeamWorkflow()) {
            Collection reviews = this.atsApi.getReviewService().getReviews((IAtsTeamWorkflow)workItem, relatedToState);
            for (IAtsAbstractReview review : reviews) {
                spent += this.atsApi.getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)review);
            }
            if (spent == 0) {
                return 0;
            }
            spent /= reviews.size();
        }
        return spent;
    }
}

