/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.task.create.IAtsTaskSetDefinitionProvider;
import org.eclipse.osee.ats.api.task.create.IAtsTaskSetDefinitionProviderService;
import org.eclipse.osee.ats.core.task.internal.AtsTaskSetDefinitionProvider;

public class AtsTaskSetDefinitionProviderService
implements IAtsTaskSetDefinitionProviderService {
    private static Map<Long, CreateTasksDefinitionBuilder> idToTaskSetDef = new HashMap<Long, CreateTasksDefinitionBuilder>();
    private static final Collection<IAtsTaskSetDefinitionProvider> taskSetDefProviders = new ArrayList<IAtsTaskSetDefinitionProvider>();
    private static final Collection<IAtsTaskSetDefinitionProvider> taskSetDefProviderProcessed = new ArrayList<IAtsTaskSetDefinitionProvider>();
    private static AtsTaskSetDefinitionProvider atsTaskSetDefProv;

    public void addTaskSetDefinitionProvider(IAtsTaskSetDefinitionProvider taskSetDefProvider) {
        taskSetDefProviders.add(taskSetDefProvider);
    }

    public synchronized void ensureLoaded() {
        if (!taskSetDefProviderProcessed.contains(atsTaskSetDefProv)) {
            atsTaskSetDefProv = new AtsTaskSetDefinitionProvider();
            taskSetDefProviders.add(atsTaskSetDefProv);
        }
        for (IAtsTaskSetDefinitionProvider workDefProvider : taskSetDefProviders) {
            if (taskSetDefProviderProcessed.contains(workDefProvider)) continue;
            for (CreateTasksDefinitionBuilder workDef : workDefProvider.getTaskSetDefinitions()) {
                idToTaskSetDef.put(workDef.getId(), workDef);
            }
            taskSetDefProviderProcessed.add(workDefProvider);
        }
    }

    public CreateTasksDefinitionBuilder getTaskSetDefinition(Long id) {
        this.ensureLoaded();
        return idToTaskSetDef.get(id);
    }

    public Collection<CreateTasksDefinitionBuilder> getAll() {
        this.ensureLoaded();
        return idToTaskSetDef.values();
    }

    public void addTaskSetDefinition(CreateTasksDefinitionBuilder workDef) {
        this.ensureLoaded();
        idToTaskSetDef.put(workDef.getId(), workDef);
    }

    public CreateTasksDefinitionBuilder getTaskSetDefinition(AtsTaskDefToken taskDefToken) {
        return this.getTaskSetDefinition(taskDefToken.getId());
    }
}

