/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.query.IAtsConfigQuery;
import org.eclipse.osee.ats.api.query.IAtsQueryFilter;
import org.eclipse.osee.ats.core.query.AtsAttributeQuery;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;

public abstract class AbstractAtsConfigQueryImpl
implements IAtsConfigQuery {
    protected final List<AtsAttributeQuery> andAttr;
    protected List<ArtifactTypeToken> artifactTypes;
    protected ArtifactId artifactId;
    protected final AtsApi atsApi;
    protected Collection<Long> aiIds;
    protected List<ArtifactId> onlyIds = null;
    protected final List<IAtsQueryFilter> queryFilters;

    public AbstractAtsConfigQueryImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
        this.andAttr = new ArrayList<AtsAttributeQuery>();
        this.aiIds = new ArrayList<Long>();
        this.queryFilters = new ArrayList<IAtsQueryFilter>();
    }

    public Collection<ArtifactId> getIds() {
        this.onlyIds = new LinkedList<ArtifactId>();
        this.getArtifacts();
        return this.onlyIds;
    }

    public abstract void createQueryBuilder();

    public <T extends IAtsConfigObject> Collection<T> getConfigObjects() {
        HashSet<IAtsConfigObject> allResults = new HashSet<IAtsConfigObject>();
        for (ArtifactToken artifact : this.getArtifacts()) {
            IAtsConfigObject configObj = AtsObjects.getConfigObject(artifact, this.atsApi);
            if (configObj == null) {
                throw new OseeArgumentException("Non-AtsConfigObject Artifact Returned %s", new Object[]{artifact.toStringWithId()});
            }
            allResults.add(configObj);
        }
        return allResults;
    }

    public <T extends IAtsConfigObject> ResultSet<T> getConfigObjectResultSet() {
        return ResultSets.newResultSet(this.getConfigObjects());
    }

    public abstract Collection<ArtifactToken> runQuery();

    public <T extends ArtifactToken> Collection<T> getArtifacts() {
        HashSet<ArtifactToken> results = new HashSet<ArtifactToken>();
        this.createQueryBuilder();
        if (this.artifactTypes != null) {
            this.queryAndIsOfType(this.artifactTypes);
        }
        if (this.artifactId != null) {
            this.queryAndArtifactId(this.artifactId);
        }
        this.addAttributeCriteria();
        if (this.isOnlyIds()) {
            this.onlyIds.addAll(this.queryGetIds());
        } else {
            Collection<ArtifactToken> artifacts = this.runQuery();
            for (ArtifactToken artifact : artifacts) {
                if (this.artifactTypes == null && !this.isArtifactTypeMatch(artifact, this.artifactTypes)) continue;
                results.add(artifact);
            }
        }
        return results;
    }

    public <T extends ArtifactToken> ResultSet<T> getArtifactResultSet() {
        return ResultSets.newResultSet(this.getArtifacts());
    }

    private boolean isArtifactTypeMatch(ArtifactToken artifact, List<ArtifactTypeToken> artTypes) {
        if (artTypes == null || artTypes.isEmpty()) {
            return true;
        }
        for (ArtifactTypeToken artType : artTypes) {
            if (!artifact.isOfType(new ArtifactTypeId[]{artType})) continue;
            return true;
        }
        return false;
    }

    public abstract void queryAndNotExists(RelationTypeSide var1);

    public abstract void queryAndExists(RelationTypeSide var1);

    public abstract void queryAndIsOfType(ArtifactTypeToken var1);

    public boolean isOnlyIds() {
        return this.onlyIds != null;
    }

    public abstract List<ArtifactId> queryGetIds();

    public IAtsConfigQuery isOfType(ArtifactTypeToken ... artifactType) {
        if (this.artifactTypes != null) {
            throw new OseeArgumentException("Can only specify one artifact type", new Object[0]);
        }
        this.artifactTypes = new LinkedList<ArtifactTypeToken>();
        ArtifactTypeToken[] artifactTypeTokenArray = artifactType;
        int n = artifactType.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactTypeToken type = artifactTypeTokenArray[n2];
            this.artifactTypes.add(type);
            ++n2;
        }
        return this;
    }

    public IAtsConfigQuery andAttr(AttributeTypeId attributeType, Collection<String> values, QueryOption ... queryOptions) {
        this.andAttr.add(new AtsAttributeQuery(attributeType, values, queryOptions));
        return this;
    }

    public IAtsConfigQuery isActive() {
        this.andAttr.add(new AtsAttributeQuery((AttributeTypeId)AtsAttributeTypes.Active, "true", new QueryOption[0]));
        return this;
    }

    public IAtsConfigQuery andId(ArtifactId artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public IAtsConfigQuery andAttr(AttributeTypeId attributeType, String value, QueryOption ... queryOption) {
        return this.andAttr(attributeType, Collections.singleton(value), queryOption);
    }

    public abstract void queryAndIsOfType(List<ArtifactTypeToken> var1);

    public abstract void queryAnd(AttributeTypeId var1, String var2);

    private void addAttributeCriteria() {
        if (!this.andAttr.isEmpty()) {
            for (AtsAttributeQuery attrQuery : this.andAttr) {
                this.queryAnd(attrQuery.getAttrType(), attrQuery.getValues(), attrQuery.getQueryOption());
            }
        }
    }

    public abstract void queryAnd(AttributeTypeId var1, Collection<String> var2, QueryOption[] var3);

    public abstract void queryAnd(AttributeTypeId var1, String var2, QueryOption[] var3);

    public abstract void queryAndArtifactId(ArtifactId var1);

    public abstract void queryAnd(AttributeTypeId var1, Collection<String> var2);

    public Collection<ArtifactTypeToken> getArtifactTypes() {
        return this.artifactTypes;
    }

    public void setArtifactType(List<ArtifactTypeToken> artifactTypes) {
        this.artifactTypes = artifactTypes;
    }

    public IAtsConfigQuery andProgram(IAtsProgram program) {
        return this.andProgram(program.getId());
    }

    public IAtsConfigQuery andProgram(Long id) {
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.ProgramId, Collections.singleton(String.valueOf(id)), new QueryOption[0]);
    }

    public IAtsConfigQuery andWorkType(WorkType workType, WorkType ... workTypes) {
        LinkedList<String> workTypeStrs = new LinkedList<String>();
        workTypeStrs.add(workType.name());
        WorkType[] workTypeArray = workTypes;
        int n = workTypes.length;
        int n2 = 0;
        while (n2 < n) {
            WorkType workType2 = workTypeArray[n2];
            workTypeStrs.add(workType2.name());
            ++n2;
        }
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.WorkType, workTypeStrs, new QueryOption[0]);
    }

    public IAtsConfigQuery andCsci(Collection<String> cscis) {
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.CSCI, cscis, new QueryOption[0]);
    }

    public IAtsConfigQuery andName(String name) {
        return this.andAttr((AttributeTypeId)CoreAttributeTypes.Name, name, new QueryOption[0]);
    }

    public IAtsConfigQuery andWorkType(Collection<WorkType> workTypes) {
        LinkedList<String> workTypeStrs = new LinkedList<String>();
        for (WorkType workType2 : workTypes) {
            workTypeStrs.add(workType2.name());
        }
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.WorkType, workTypeStrs, new QueryOption[0]);
    }

    public IAtsConfigQuery andTag(String ... tags) {
        List<String> values = Arrays.asList(tags);
        return this.andAttr((AttributeTypeId)CoreAttributeTypes.StaticId, values, QueryOption.EXACT_MATCH_OPTIONS);
    }

    public IAtsConfigQuery andActive(boolean active) {
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.Active, active ? "true" : "false", new QueryOption[0]);
    }

    public <T extends IAtsConfigObject> Collection<T> getItems(Class<T> clazz) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(this.getConfigObjects());
    }

    protected OseeCoreException createManyExistException(int count) {
        return new MultipleItemsExist("Multiple items found - total [%s]", new Object[]{count});
    }

    protected OseeCoreException createDoesNotExistException() {
        return new ItemDoesNotExist("No item found", new Object[0]);
    }

    public <T extends IAtsConfigObject> T getOneOrNull(Class<T> clazz) {
        Collection<T> items = this.getItems(clazz);
        if (!items.isEmpty()) {
            return (T)((IAtsConfigObject)items.iterator().next());
        }
        return null;
    }

    public <T extends IAtsConfigObject> T getAtMostOneOrNull(Class<T> clazz) {
        IAtsConfigObject result = null;
        Collection<T> items = this.getItems(clazz);
        if (items != null) {
            int size = items.size();
            if (size > 1) {
                throw this.createManyExistException(size);
            }
            if (size == 1) {
                result = (IAtsConfigObject)items.iterator().next();
            }
        }
        return (T)result;
    }

    public <T extends IAtsConfigObject> T getExactlyOne(Class<T> clazz) {
        T result = this.getAtMostOneOrNull(clazz);
        if (result == null) {
            throw this.createDoesNotExistException();
        }
        return result;
    }

    public <T extends IAtsConfigObject> T getOneOrDefault(Class<T> clazz, T defaultValue) {
        int size;
        Collection<T> items = this.getItems(clazz);
        if (items != null && (size = items.size()) > 0) {
            defaultValue = (IAtsConfigObject)items.iterator().next();
        }
        return defaultValue;
    }
}

