/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinitionService;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class TeamDefinitionServiceImpl
implements IAtsTeamDefinitionService {
    private final AtsApi atsApi;

    public TeamDefinitionServiceImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public TeamDefinition getTeamDefinitionById(ArtifactId teamDefId) {
        TeamDefinition teamDef = null;
        if (teamDefId instanceof TeamDefinition) {
            teamDef = (TeamDefinition)teamDefId;
        }
        if (teamDef == null) {
            teamDef = (TeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(teamDefId.getId());
        }
        if (teamDef == null) {
            if (this.atsApi.isIde()) {
                teamDef = this.atsApi.getServerEndpoints().getConfigEndpoint().getTeamDefinition(ArtifactId.valueOf((Long)teamDefId.getId()));
                teamDef.setAtsApi(this.atsApi);
            } else {
                ArtifactToken teamDefArt = this.atsApi.getQueryService().getArtifact(teamDefId);
                if (teamDefArt != null && teamDefArt.isValid()) {
                    TeamDefinition teamDef2 = this.createTeamDefinition(teamDefArt);
                    this.atsApi.getConfigService().getConfigurations().addTeamDef(teamDef2);
                    teamDef = teamDef2;
                }
            }
        }
        return teamDef;
    }

    public TeamDefinition createTeamDefinition(ArtifactToken teamDefArt) {
        TeamDefinition teamDef = new TeamDefinition(teamDefArt, this.atsApi);
        teamDef.setName(teamDefArt.getName());
        teamDef.setId(teamDefArt.getId());
        teamDef.setGuid(teamDefArt.getGuid());
        teamDef.setActive(((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)teamDefArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true)).booleanValue());
        for (String workTypeStr : this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)teamDefArt, (AttributeTypeToken)AtsAttributeTypes.WorkType)) {
            WorkType workType = WorkType.valueOfOrNone((String)workTypeStr);
            if (!workType.isNotNone()) continue;
            teamDef.getWorkTypes().add(workType);
        }
        teamDef.getTags().addAll(this.atsApi.getAttributeResolver().getAttributeValues((ArtifactId)teamDefArt, (AttributeTypeToken)CoreAttributeTypes.StaticId));
        Collection ais = this.atsApi.getRelationResolver().getRelated((ArtifactId)teamDefArt, AtsRelationTypes.TeamActionableItem_ActionableItem);
        ArtifactId programId = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)teamDefArt, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)ArtifactId.SENTINEL);
        if (programId.isValid()) {
            teamDef.setProgramId(programId.getIdString());
        }
        for (String csci : this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)teamDefArt, (AttributeTypeToken)AtsAttributeTypes.CSCI)) {
            teamDef.getCscis().add(csci);
        }
        for (ArtifactToken ai : ais) {
            teamDef.addAi(ai);
        }
        ArtifactToken parent = this.atsApi.getRelationResolver().getParent((ArtifactId)teamDefArt);
        if (parent != null) {
            teamDef.setParentId(parent.getId());
        }
        for (ArtifactToken child : this.atsApi.getRelationResolver().getChildren((ArtifactId)teamDefArt)) {
            if (!child.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) continue;
            teamDef.getChildren().add(child.getId());
        }
        return teamDef;
    }

    public TeamDefinition getTeamDefinition(IAtsWorkItem workItem) {
        ArtifactId teamDefId = this.atsApi.getAttributeResolver().getSoleArtifactIdReference((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, ArtifactId.SENTINEL);
        TeamDefinition teamDef = null;
        if (teamDefId.isValid()) {
            teamDef = this.getTeamDefinitionById(teamDefId);
        }
        return teamDef;
    }

    public Collection<IAtsVersion> getVersions(IAtsTeamDefinition teamDef) {
        ArrayList<IAtsVersion> versions = new ArrayList<IAtsVersion>();
        TeamDefinition teamD = this.atsApi.getConfigService().getConfigurations().getTeamDef(teamDef);
        for (Long verId : teamD.getVersions()) {
            Version version = (Version)this.atsApi.getConfigService().getConfigurations().getIdToVersion().get(verId);
            versions.add((IAtsVersion)version);
        }
        return versions;
    }

    public IAtsTeamDefinition getTeamDefHoldingVersions(IAtsTeamDefinition teamDef) {
        return this.atsApi.getVersionService().getTeamDefinitionHoldingVersions(teamDef);
    }

    public IAtsTeamDefinition getTeamDefHoldingVersions(IAtsProgram program) {
        return this.atsApi.getProgramService().getTeamDefHoldingVersions(program);
    }

    public IAtsTeamDefinition getTeamDefinition(String name) {
        TeamDefinition teamDef = null;
        for (TeamDefinition teamD : this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().values()) {
            if (!teamD.getName().equals(name)) continue;
            teamDef = teamD;
            break;
        }
        return teamDef;
    }

    public Collection<IAtsTeamDefinition> getTeamDefinitions(IAgileTeam agileTeam) {
        LinkedList<IAtsTeamDefinition> teamDefs = new LinkedList<IAtsTeamDefinition>();
        for (ArtifactId teamDef : this.atsApi.getRelationResolver().getRelated((IAtsObject)agileTeam, AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam)) {
            teamDefs.add((IAtsTeamDefinition)this.getTeamDefinitionById(teamDef));
        }
        return teamDefs;
    }

    public TeamDefinition createTeamDefinition(String name, long id, IAtsChangeSet changes) {
        ArtifactToken artifact = changes.createArtifact(AtsArtifactTypes.TeamDefinition, name, Long.valueOf(id));
        return this.createTeamDefinition(artifact);
    }

    public TeamDefinition createTeamDefinition(String name, IAtsChangeSet changes) {
        return this.createTeamDefinition(name, Lib.generateArtifactIdAsInt(), changes);
    }

    public Collection<AtsUser> getLeads(IAtsTeamDefinition teamDef, Collection<IAtsActionableItem> actionableItems) {
        HashSet<AtsUser> leads = new HashSet<AtsUser>();
        for (IAtsActionableItem aia : actionableItems) {
            if (!teamDef.equals(aia.getAtsApi().getActionableItemService().getTeamDefinitionInherited(aia))) continue;
            Collection leads2 = this.atsApi.getActionableItemService().getLeads(aia);
            if (leads2.size() > 0) {
                leads.addAll(leads2);
                continue;
            }
            if (aia.getAtsApi().getActionableItemService().getTeamDefinitionInherited(aia) == null) continue;
            Collection<AtsUser> leads3 = this.getLeads(aia.getAtsApi().getActionableItemService().getTeamDefinitionInherited(aia));
            leads.addAll(leads3);
        }
        if (leads.isEmpty()) {
            Collection<AtsUser> leads2 = this.getLeads(teamDef);
            leads.addAll(leads2);
        }
        return leads;
    }

    public Collection<AtsUser> getLeads(IAtsTeamDefinition teamDef) {
        return this.atsApi.getUserService().getRelatedUsers(this.atsApi, teamDef.getStoreObject(), AtsRelationTypes.TeamLead_Lead);
    }

    public Collection<AtsUser> getMembers(IAtsTeamDefinition teamDef) {
        return this.atsApi.getUserService().getRelatedUsers(this.atsApi, teamDef.getArtifactToken(), AtsRelationTypes.TeamMember_Member);
    }

    public Collection<AtsUser> getSubscribed(IAtsTeamDefinition teamDef) {
        return this.atsApi.getUserService().getRelatedUsers(this.atsApi, teamDef.getArtifactToken(), AtsRelationTypes.SubscribedUser_User);
    }

    public Collection<AtsUser> getMembersAndLeads(IAtsTeamDefinition teamDef) {
        HashSet<AtsUser> results = new HashSet<AtsUser>();
        results.addAll(this.getLeads(teamDef));
        results.addAll(this.getMembers(teamDef));
        return results;
    }

    public boolean isAllowCommitBranch(IAtsTeamDefinition teamDef) {
        return (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.AllowCommitBranch, (Object)false);
    }

    public Result isAllowCommitBranchInherited(IAtsTeamDefinition teamDef) {
        if (!this.isAllowCommitBranch(teamDef)) {
            return new Result(false, "Team Definition [" + this + "] not configured to allow branch commit.");
        }
        if (this.getBaselineBranchId(teamDef).isInvalid()) {
            return new Result(false, "Parent Branch not configured for Team Definition [" + this + "]");
        }
        return Result.TrueResult;
    }

    public boolean isAllowCreateBranch(IAtsTeamDefinition teamDef) {
        return (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.AllowCreateBranch, (Object)false);
    }

    public Result isAllowCreateBranchInherited(IAtsTeamDefinition teamDef) {
        if (!this.isAllowCreateBranch(teamDef)) {
            return new Result(false, "Branch creation disabled for Team Definition [" + this + "]");
        }
        if (this.getBaselineBranchId(teamDef).isInvalid()) {
            return new Result(false, "Parent Branch not configured for Team Definition [" + this + "]");
        }
        return Result.TrueResult;
    }

    public BranchId getBaselineBranchId(IAtsTeamDefinition teamDef) {
        return BranchId.valueOf((String)((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)"0")));
    }

    public BranchId getTeamBranchId(IAtsTeamDefinition teamDef) {
        BranchId branch = this.getBaselineBranchId(teamDef);
        if (branch.isValid()) {
            return branch;
        }
        TeamDefinition parentTeamDef = this.getParentTeamDef(teamDef);
        if (parentTeamDef != null) {
            return this.getTeamBranchId((IAtsTeamDefinition)parentTeamDef);
        }
        return BranchId.SENTINEL;
    }

    public TeamDefinition getParentTeamDef(IAtsTeamDefinition teamDef) {
        TeamDefinition teamD = this.atsApi.getConfigService().getConfigurations().getTeamDef(teamDef);
        TeamDefinition parent = (TeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(teamD.getParentId());
        return parent;
    }

    public Collection<TeamDefinition> getChildrenTeamDefinitions(IAtsTeamDefinition teamDef) {
        TeamDefinition teamD = this.atsApi.getConfigService().getConfigurations().getTeamDef(teamDef);
        return teamD.getChildrenTeamDefs();
    }

    public boolean isTeamUsesVersions(IAtsTeamDefinition teamDef) {
        return this.atsApi.getVersionService().isTeamUsesVersions(teamDef);
    }

    public IAtsTeamDefinition getTeamDefinitionHoldingVersions(IAtsTeamDefinition teamDef) {
        return this.atsApi.getVersionService().getTeamDefinitionHoldingVersions(teamDef);
    }

    public Collection<String> getRules(IAtsTeamDefinition teamDef) {
        List rules = this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.RuleDefinition);
        return rules;
    }

    public boolean hasRule(IAtsTeamDefinition teamDef, String rule) {
        boolean result = false;
        for (String rule2 : this.getRules(teamDef)) {
            if (!rule.equals(rule2)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Collection<TeamDefinition> getTopLevelTeamDefinitions(Active active) {
        ArrayList<TeamDefinition> teamDefs = new ArrayList<TeamDefinition>();
        IAtsTeamDefinition topTeamDef = this.getTopTeamDefinitionOrSentinel();
        if (topTeamDef.isValid()) {
            TeamDefinition tTeamDef = this.getTeamDefinitionById((ArtifactId)topTeamDef.getStoreObject());
            return tTeamDef.getChildrenTeamDefs();
        }
        return teamDefs;
    }

    public List<IAtsTeamDefinition> getActive(Collection<IAtsTeamDefinition> teamDefs, Active active) {
        ArrayList<IAtsTeamDefinition> results = new ArrayList<IAtsTeamDefinition>();
        for (IAtsTeamDefinition teamDef : teamDefs) {
            if (active == Active.Both) {
                results.add(teamDef);
                continue;
            }
            boolean attributeActive = teamDef.isActive();
            if (active == Active.Active && attributeActive) {
                results.add(teamDef);
                continue;
            }
            if (active != Active.InActive || attributeActive) continue;
            results.add(teamDef);
        }
        return results;
    }

    public Set<IAtsTeamDefinition> getChildren(IAtsTeamDefinition teamDef, boolean recurse) {
        HashSet<IAtsTeamDefinition> children = new HashSet<IAtsTeamDefinition>();
        Collection<TeamDefinition> cTeamDefs = this.getChildrenTeamDefinitions(teamDef);
        for (IAtsTeamDefinition iAtsTeamDefinition : cTeamDefs) {
            children.add(iAtsTeamDefinition);
            if (!recurse) continue;
            Set<IAtsTeamDefinition> children2 = this.getChildren(iAtsTeamDefinition, recurse);
            children.addAll(children2);
        }
        return children;
    }

    public List<IAtsTeamDefinition> getTeamDefinitions(Active active) {
        ArrayList<IAtsTeamDefinition> teamDefs = new ArrayList<IAtsTeamDefinition>();
        for (IAtsTeamDefinition teamDef : this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().values()) {
            if (!teamDef.isActive()) continue;
            teamDefs.add(teamDef);
        }
        return teamDefs;
    }

    public Collection<TeamDefinition> getTeamTopLevelDefinitions(Active active) {
        IAtsTeamDefinition topTeamDef = this.getTopTeamDefinitionOrSentinel();
        if (topTeamDef.isInvalid()) {
            return Collections.emptyList();
        }
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(this.getActive(this.getChildren(topTeamDef, false), active));
    }

    public IAtsTeamDefinition getTopTeamDefinition() {
        return (IAtsTeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(this.atsApi.getConfigService().getConfigurations().getTopTeamDefinition().getId());
    }

    public IAtsTeamDefinition getTopTeamDefinitionOrSentinel() {
        IAtsTeamDefinition teamDef = this.getTopTeamDefinition();
        if (teamDef == null) {
            return IAtsTeamDefinition.SENTINEL;
        }
        return teamDef;
    }

    public Set<IAtsTeamDefinition> getTeamReleaseableDefinitions(Active active) {
        HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
        for (IAtsTeamDefinition teamDef : this.getTeamDefinitions(active)) {
            if (this.atsApi.getVersionService().getVersions(teamDef).size() <= 0) continue;
            teamDefs.add(teamDef);
        }
        return teamDefs;
    }

    public Set<IAtsTeamDefinition> getTeamsFromItemAndChildren(IAtsActionableItem ai) {
        HashSet<IAtsTeamDefinition> aiTeams = new HashSet<IAtsTeamDefinition>();
        this.getTeamFromItemAndChildren(ai, aiTeams);
        return aiTeams;
    }

    public Set<IAtsTeamDefinition> getTeamsFromItemAndChildren(IAtsTeamDefinition teamDef) {
        HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
        teamDefs.add(teamDef);
        for (IAtsTeamDefinition child : this.atsApi.getTeamDefinitionService().getChildrenTeamDefinitions(teamDef)) {
            teamDefs.addAll(this.getTeamsFromItemAndChildren(child));
        }
        return teamDefs;
    }

    public void getTeamFromItemAndChildren(IAtsActionableItem ai, Set<IAtsTeamDefinition> aiTeams) {
        if (ai.getTeamDefinition() != null) {
            aiTeams.add(ai.getTeamDefinition());
        }
        for (IAtsActionableItem childArt : ai.getChildrenActionableItems()) {
            this.getTeamFromItemAndChildren(childArt, aiTeams);
        }
    }

    public Set<IAtsTeamDefinition> getTeamDefinitions(Collection<String> teamDefNames) {
        HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
        for (IAtsTeamDefinition teamDef : this.getTeamDefinitions(Active.Both)) {
            if (!teamDefNames.contains(teamDef.getName())) continue;
            teamDefs.add(teamDef);
        }
        return teamDefs;
    }

    public Set<IAtsTeamDefinition> getTeamDefinitionsNameStartsWith(String prefix) {
        HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
        for (IAtsTeamDefinition teamDef : this.getTeamDefinitions(Active.Both)) {
            if (!teamDef.getName().startsWith(prefix)) continue;
            teamDefs.add(teamDef);
        }
        return teamDefs;
    }

    public Collection<IAtsTeamDefinition> getImpactedTeamDefs(Collection<IAtsActionableItem> ais) {
        HashSet<IAtsTeamDefinition> resultTeams = new HashSet<IAtsTeamDefinition>();
        for (IAtsActionableItem ai : ais) {
            resultTeams.addAll(this.getImpactedTeamDefInherited(ai));
        }
        return resultTeams;
    }

    public IAtsTeamDefinition getImpactedTeamDef(IAtsActionableItem ai) {
        if (ai.getTeamDefinition() != null) {
            return ai.getTeamDefinition();
        }
        if (ai.getParentActionableItem() != null) {
            return this.getImpactedTeamDef(ai.getParentActionableItem());
        }
        return null;
    }

    public Collection<IAtsTeamDefinition> getImpactedTeamDefInherited(IAtsActionableItem ai) {
        if (ai == null) {
            return Collections.emptyList();
        }
        if (ai.getTeamDefinition() != null) {
            return Collections.singleton(ai.getTeamDefinition());
        }
        IAtsActionableItem parentArt = ai.getParentActionableItem();
        return this.getImpactedTeamDefInherited(parentArt);
    }

    public Collection<TeamDefinition> getTeamTopLevelJaxDefinitions(Active active) {
        LinkedList<TeamDefinition> teamDefs = new LinkedList<TeamDefinition>();
        TeamDefinition topTeam = (TeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(this.atsApi.getConfigService().getConfigurations().getTopTeamDefinition().getId());
        for (Long id : topTeam.getChildren()) {
            teamDefs.add((TeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(id));
        }
        return teamDefs;
    }

    public Collection<IAtsTeamDefinition> getTeamDefs(Collection<TeamDefinition> teamDefs) {
        LinkedList<IAtsTeamDefinition> teamDefs2 = new LinkedList<IAtsTeamDefinition>();
        for (TeamDefinition teamDef : teamDefs) {
            teamDefs2.add((IAtsTeamDefinition)this.atsApi.getQueryService().getConfigItem(teamDef.getId()));
        }
        return teamDefs2;
    }

    public Collection<IAtsTeamDefinition> getTeamDefHoldingVersions() {
        LinkedList<IAtsTeamDefinition> teamDefs = new LinkedList<IAtsTeamDefinition>();
        for (TeamDefinition teamDef : this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().values()) {
            if (teamDef.getVersions().isEmpty()) continue;
            teamDefs.add((IAtsTeamDefinition)teamDef);
        }
        return teamDefs;
    }
}

