/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writers;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.model.GenericReport;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.ReportColumn;
import org.eclipse.osee.orcs.search.ReportFilter;
import org.eclipse.osee.orcs.search.ReportLevel;

public class GenericReportBuilder
implements GenericReport {
    private final List<ReportLevel> reportLevels = new LinkedList<ReportLevel>();
    private final OrcsApi orcsApi;
    private QueryBuilder query;
    private ReportLevel currentLevel = null;

    public GenericReportBuilder(BranchId branch, ArtifactId view, OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.query = orcsApi.getQueryFactory().fromBranch(branch, view);
    }

    public int getColumnCount() {
        int count = 0;
        for (ReportLevel level : this.reportLevels) {
            count += level.getColumns().size();
        }
        return count;
    }

    public GenericReport level(String levelName, QueryBuilder addedQuery) {
        int depth = 0;
        if (this.currentLevel != null) {
            depth = this.currentLevel.getDepth() + 1;
        }
        this.currentLevel = new ReportLevel(levelName);
        this.currentLevel.setDepth(depth);
        this.reportLevels.add(this.currentLevel);
        this.query = addedQuery;
        return this;
    }

    public GenericReport level(String levelName, String typeName) {
        int depth = 0;
        if (this.currentLevel != null) {
            depth = this.currentLevel.getDepth() + 1;
        }
        this.currentLevel = new ReportLevel(levelName);
        this.currentLevel.setDepth(depth);
        this.reportLevels.add(this.currentLevel);
        this.query = this.query.andIsOfType(new ArtifactTypeToken[]{this.orcsApi.tokenService().getArtifactType(typeName)});
        return this;
    }

    public GenericReport column(String columnName) {
        this.currentLevel.column(columnName);
        return this;
    }

    public GenericReport column(String columnName, String typeName) {
        AttributeTypeGeneric type = this.orcsApi.tokenService().getAttributeType(typeName);
        this.currentLevel.column(columnName, (AttributeTypeToken)type);
        return this;
    }

    public GenericReport column(String columnName, AttributeTypeToken type) {
        this.currentLevel.column(columnName, type);
        return this;
    }

    public GenericReport column(AttributeTypeToken type) {
        this.currentLevel.column(type);
        return this;
    }

    public GenericReport type(String columnName) {
        this.currentLevel.type(columnName);
        return this;
    }

    public GenericReport filter(AttributeTypeToken type, String regex) {
        this.currentLevel.filter(type, regex);
        return this;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public List<ReportLevel> getLevels() {
        return this.reportLevels;
    }

    public String[] getTopRow() {
        String[] row = new String[this.getColumnCount()];
        int pos = 0;
        for (ReportLevel level : this.getLevels()) {
            row[pos] = level.getLevelName();
            List columns = level.getColumns();
            int i = 0;
            while (i < columns.size()) {
                if (i != 0) {
                    row[pos] = null;
                }
                ++pos;
                ++i;
            }
        }
        return row;
    }

    public String[] getHeaderRow() {
        String[] row = new String[this.getColumnCount()];
        int pos = 0;
        for (ReportLevel level : this.getLevels()) {
            List columns = level.getColumns();
            int i = 0;
            while (i < columns.size()) {
                row[pos] = ((ReportColumn)columns.get(i)).getName();
                ++pos;
                ++i;
            }
        }
        return row;
    }

    public void getDataRowsFromQuery(List<Object[]> rows) {
        List arts = this.query.asArtifacts();
        if (arts.isEmpty()) {
            throw new OseeCoreException("Invalid Query in GenericReportBuilder", new Object[0]);
        }
        rows.add(this.getTopRow());
        rows.add(this.getHeaderRow());
        String[] row = new String[this.getColumnCount()];
        for (ArtifactReadable art : arts) {
            this.fillReportDataFromQuery(art, rows, row, 0, 0);
        }
    }

    private boolean isFinalLevel(int depth) {
        return depth == this.getLevels().size() - 1;
    }

    private void fillReportDataFromQuery(ArtifactReadable art, List<Object[]> rows, String[] row, int pos, int depth) {
        ReportLevel level = this.getLevels().get(depth);
        for (ReportColumn column : level.getColumns()) {
            String columnData = column.getReportData(art);
            for (ReportFilter filter : column.getFilters()) {
                try {
                    if (!filter.filterMatches(columnData).booleanValue()) continue;
                    return;
                }
                catch (Exception exception) {}
            }
            row[pos++] = columnData;
        }
        if (this.isFinalLevel(depth)) {
            this.finishRow(rows, row, pos);
        } else {
            level = this.getLevels().get(++depth);
            List<ArtifactReadable> arts = this.getArtsForLevel(art, level);
            if (arts.isEmpty()) {
                this.finishRow(rows, row, pos);
            } else {
                for (ArtifactReadable child : arts) {
                    this.fillReportDataFromQuery(child, rows, row, pos, depth);
                }
            }
        }
    }

    private void finishRow(List<Object[]> rows, String[] row, int pos) {
        String[] setrow = new String[this.getColumnCount()];
        int i = 0;
        while (i < pos) {
            setrow[i] = row[i];
            ++i;
        }
        rows.add(setrow);
    }

    private List<ArtifactReadable> getArtsForLevel(ArtifactReadable art, ReportLevel level) {
        LinkedList<ArtifactReadable> arts = new LinkedList<ArtifactReadable>();
        int depth = level.getDepth();
        if (depth == 0) {
            arts.addAll(this.query.asArtifacts());
        } else {
            if (level.getRelation() == null) {
                List relations = this.query.getRelationTypesForLevel(depth);
                if (relations.isEmpty()) {
                    throw new OseeCoreException("Relation not found for level %d", new Object[]{depth});
                }
                if (relations.size() > 1) {
                    throw new OseeCoreException("Multiple relations in one level not implemented for Generic Report", new Object[0]);
                }
                RelationTypeSide relation = (RelationTypeSide)relations.get(0);
                if (relation.isValid()) {
                    level.setRelation(relation);
                } else {
                    throw new OseeCoreException("Invalid relation found for level %d", new Object[]{depth});
                }
            }
            arts.addAll(art.getRelated(level.getRelation(), DeletionFlag.EXCLUDE_DELETED));
        }
        return arts;
    }
}

