/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.ActivityEntry;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;

public class ServerHealthUsage {
    private static final String ALL_USERS = "All Users";
    private final JdbcClient jdbcClient;
    private final OrcsApi orcsApi;
    private final Pattern verPattern = Pattern.compile("\"version\":\"(.*?)\"");
    private final HashCollectionSet<String, String> byCategory = new HashCollectionSet();
    private final UriInfo uriInfo;

    public ServerHealthUsage(UriInfo uriInfo, OrcsApi orcsApi, JdbcClient jdbcClient) {
        this.uriInfo = uriInfo;
        this.orcsApi = orcsApi;
        this.jdbcClient = jdbcClient;
    }

    public String getHtml() {
        MultivaluedMap queryParameters = this.uriInfo.getQueryParameters(true);
        String months = "1";
        Set entrySet = queryParameters.entrySet();
        if (!entrySet.isEmpty()) {
            for (Map.Entry entry : entrySet) {
                if (!((String)entry.getKey()).toLowerCase().equals("months")) continue;
                months = (String)((List)entry.getValue()).iterator().next();
            }
        }
        if (!Strings.isNumeric((String)months)) {
            return AHTML.simplePage((String)("Invalid Months = " + months));
        }
        return this.getHtml(months);
    }

    public String getHtml(String months) {
        Collection<ActivityEntry> logMsgs = this.getUsageLogEntries(months);
        return this.getHtml(String.format("OSEE usage in past %s month(s) as of %s", months, DateUtil.getDateNow()), logMsgs);
    }

    private String getHtml(String title, Collection<ActivityEntry> logMsgs) {
        StringBuilder sb = new StringBuilder();
        sb.append(AHTML.heading((int)2, (String)title));
        StringBuilder usageSb = this.addUsageTable(logMsgs);
        this.addCategoryTables(sb);
        sb.append("<br/><br/>");
        sb.append(AHTML.heading((int)3, (String)"By Session"));
        sb.append(usageSb.toString());
        sb.append("<br/><br/>");
        return sb.toString();
    }

    private void addCategoryTables(StringBuilder sb) {
        sb.append(AHTML.heading((int)3, (String)ALL_USERS));
        this.extracted(sb, ALL_USERS, (Set)this.byCategory.getValues((Object)ALL_USERS), "Users");
        sb.append(AHTML.heading((int)3, (String)"By Release Type"));
        for (String category : Arrays.asList("-DEV", "Development", "-REL", "-NR", "local")) {
            this.handleCategory(sb, category);
        }
        sb.append(AHTML.heading((int)3, (String)"By Release Version"));
        for (Map.Entry entry : this.byCategory.entrySet()) {
            if (((String)entry.getKey()).equals(ALL_USERS)) continue;
            this.extracted(sb, (String)entry.getKey(), (Set)entry.getValue(), "Release Version");
        }
    }

    private void handleCategory(StringBuilder sb, String category) {
        HashSet<String> values = new HashSet<String>();
        for (Map.Entry entry : this.byCategory.entrySet()) {
            if (!((String)entry.getKey()).contains(category)) continue;
            values.addAll((Collection)entry.getValue());
        }
        this.extracted(sb, category, values, "Release Type");
    }

    private void extracted(StringBuilder sb, String category, Set<String> values, String categoryName) {
        sb.append(AHTML.heading((int)4, (String)String.format("---  %s: %s - Count: %s", categoryName, category, values.size())));
        sb.append("Users: " + Collections.toString((String)"; ", values));
    }

    private StringBuilder addUsageTable(Collection<ActivityEntry> logMsgs) {
        StringBuilder usageSb = new StringBuilder();
        usageSb.append(AHTML.beginMultiColumnTable((int)95, (int)1));
        usageSb.append(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Date", "Account", "User", "UserId", "Version", "Msg")));
        for (ActivityEntry entry : logMsgs) {
            UserToken user = this.orcsApi.userService().getUser(entry.getAccountId());
            String version = "Unknown";
            Matcher m = this.verPattern.matcher(entry.getMessageArgs());
            if (m.find()) {
                version = m.group(1);
            }
            this.byCategory.put((Object)version, (Object)user.getName());
            this.byCategory.put((Object)ALL_USERS, (Object)user.getName());
            usageSb.append(AHTML.addRowMultiColumnTable((String[])new String[]{entry.getStartTimestamp().toString(), entry.getAccountId().toString(), user.getName(), user.getUserId(), version, entry.getMessageArgs()}));
        }
        usageSb.append(AHTML.endMultiColumnTable());
        return usageSb;
    }

    private Collection<ActivityEntry> getUsageLogEntries(String months) {
        Calendar cal = Calendar.getInstance();
        int minusMonths = Integer.valueOf(months) * -1;
        cal.add(2, minusMonths);
        Date date = cal.getTime();
        String query = "select * from osee_activity where type_id = " + CoreActivityTypes.IDE.getIdString() + " and trunc(start_timestamp) > '" + DateUtil.get((Date)date, (String)"dd_MMM_yyyy") + "' and msg_args like '%Session Created%' order by start_timestamp desc";
        return this.getLogEntries(query);
    }

    private Collection<ActivityEntry> getLogEntries(String query) {
        ArrayList<ActivityEntry> logMsgs = new ArrayList<ActivityEntry>();
        System.err.println("query: " + query);
        Consumer<JdbcStatement> consumer = stmt -> {
            ActivityEntry entry = new ActivityEntry(Long.valueOf(stmt.getLong(1)));
            entry.setAccountId(Long.valueOf(stmt.getLong("account_id")));
            entry.setClientId(Long.valueOf(stmt.getLong("client_id")));
            entry.setDuration(Long.valueOf(stmt.getLong("duration")));
            entry.setMessageArgs(stmt.getString("msg_args"));
            entry.setParentId(Long.valueOf(stmt.getLong("parent_id")));
            entry.setServerId(Long.valueOf(stmt.getLong("server_id")));
            entry.setStartTime(Long.valueOf(stmt.getLong("start_time")));
            entry.setStartTimestamp(stmt.getTimestamp("start_timestamp"));
            entry.setStatus(Integer.valueOf(stmt.getInt("status")));
            entry.setTypeId(Long.valueOf(stmt.getLong("type_id")));
            logMsgs.add(entry);
        };
        this.jdbcClient.runQuery(consumer, query, new Object[0]);
        return logMsgs;
    }
}

