/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceEnumerationApi;
import org.eclipse.osee.mim.InterfaceEnumerationSetApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.PlatformTypesEndpoint;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class PlatformTypesEndpointImpl
implements PlatformTypesEndpoint {
    private final BranchId branch;
    private final InterfacePlatformTypeApi platformApi;
    private final InterfaceEnumerationSetApi enumSetApi;
    private final InterfaceEnumerationApi enumApi;

    public PlatformTypesEndpointImpl(BranchId branch, InterfacePlatformTypeApi api, InterfaceEnumerationSetApi enumSetApi, InterfaceEnumerationApi enumApi) {
        this.branch = branch;
        this.platformApi = api;
        this.enumSetApi = enumSetApi;
        this.enumApi = enumApi;
    }

    @Override
    public Collection<PlatformTypeToken> getPlatformTypes(long pageNum, long pageSize, AttributeTypeToken orderByAttributeTypeId) {
        return this.platformApi.getAllWithEnumSet(this.branch, pageNum, pageSize, (AttributeTypeId)orderByAttributeTypeId);
    }

    @Override
    public PlatformTypeToken getPlatformType(ArtifactId typeId) {
        return this.platformApi.get(this.branch, typeId);
    }

    @Override
    public InterfaceEnumerationSet getRelatedEnumerationSet(ArtifactId typeId) {
        try {
            List enumSets = (List)this.enumSetApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfacePlatformTypeEnumeration_Element, typeId, InterfaceEnumerationSet.class);
            for (InterfaceEnumerationSet set : enumSets) {
                set.setEnumerations((List)this.enumApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceEnumeration_EnumerationSet, ArtifactId.valueOf((Long)set.getId()), InterfaceEnumeration.class));
            }
            return (InterfaceEnumerationSet)((Object)enumSets.get(0));
        }
        catch (Exception ex) {
            System.out.println(ex);
            return null;
        }
    }
}

