/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceDifferenceReportApi;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceEnumerationApi;
import org.eclipse.osee.mim.InterfaceEnumerationSetApi;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.MimDifferenceItem;
import org.eclipse.osee.mim.types.MimDifferenceReport;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class InterfaceDifferenceReportApiImpl
implements InterfaceDifferenceReportApi {
    private BranchId branch1;
    private BranchId branch2;
    private final OrcsApi orcsApi;
    private final InterfaceNodeViewApi interfaceNodeApi;
    private final InterfaceConnectionViewApi interfaceConnectionApi;
    private final InterfaceMessageApi interfaceMessageApi;
    private final InterfaceSubMessageApi interfaceSubMessageApi;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceElementApi interfaceElementApi;
    private final InterfacePlatformTypeApi interfacePlatformApi;
    private final InterfaceEnumerationSetApi interfaceEnumerationSetApi;
    private final InterfaceEnumerationApi interfaceEnumerationApi;
    private Map<ArtifactId, List<ChangeItem>> changeMap;
    private List<ArtifactId> nodeList;
    private List<ArtifactId> connectionList;
    private List<ArtifactId> messageList;
    private List<ArtifactId> submessageList;
    private List<ArtifactId> structureList;
    private List<ArtifactId> elementList;
    private List<ArtifactId> pTypeList;
    private List<ArtifactId> enumList;
    private MimDifferenceReport diffReport;

    InterfaceDifferenceReportApiImpl(OrcsApi orcsApi, InterfaceNodeViewApi interfaceNodeApi, InterfaceConnectionViewApi interfaceConnectionViewApi, InterfaceMessageApi interfaceMessageApi, InterfaceSubMessageApi interfaceSubMessageApi, InterfaceStructureApi interfaceStructureApi, InterfaceElementApi interfaceElementApi, InterfacePlatformTypeApi interfacePlatformApi, InterfaceEnumerationSetApi interfaceEnumerationSetApi, InterfaceEnumerationApi interfaceEnumerationApi) {
        this.orcsApi = orcsApi;
        this.interfaceNodeApi = interfaceNodeApi;
        this.interfaceConnectionApi = interfaceConnectionViewApi;
        this.interfaceMessageApi = interfaceMessageApi;
        this.interfaceSubMessageApi = interfaceSubMessageApi;
        this.interfaceStructureApi = interfaceStructureApi;
        this.interfaceElementApi = interfaceElementApi;
        this.interfacePlatformApi = interfacePlatformApi;
        this.interfaceEnumerationSetApi = interfaceEnumerationSetApi;
        this.interfaceEnumerationApi = interfaceEnumerationApi;
    }

    @Override
    public MimDifferenceReport getDifferenceReport(BranchId branch1, BranchId branch2) {
        this.branch1 = branch1;
        this.branch2 = branch2;
        this.changeMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.diffReport = new MimDifferenceReport();
        this.nodeList = new LinkedList<ArtifactId>();
        this.connectionList = new LinkedList<ArtifactId>();
        this.messageList = new LinkedList<ArtifactId>();
        this.submessageList = new LinkedList<ArtifactId>();
        this.structureList = new LinkedList<ArtifactId>();
        this.elementList = new LinkedList<ArtifactId>();
        this.pTypeList = new LinkedList<ArtifactId>();
        this.enumList = new LinkedList<ArtifactId>();
        TransactionToken sourceTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch1)).getResults().getExactlyOne();
        TransactionToken destinationTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch2)).getResults().getExactlyOne();
        List changes = this.orcsApi.getBranchOps().compareBranch(sourceTx, destinationTx);
        changes.stream().filter(c -> c.getChangeType().getId() == ChangeType.Artifact.getId() || c.getChangeType().getId() == ChangeType.Relation.getId()).forEach(c -> this.addChangeToMap((ChangeItem)c));
        for (ChangeItem change : changes) {
            List<ChangeItem> list = this.getChangeList(change.getArtId());
            list.add(change);
            this.changeMap.put(change.getArtId(), list);
        }
        for (ArtifactId artId : this.nodeList) {
            this.processNode(artId);
        }
        for (ArtifactId artId : this.connectionList) {
            this.processConnection(artId);
        }
        for (ArtifactId artId : this.messageList) {
            this.processMessage(artId);
        }
        for (ArtifactId artId : this.submessageList) {
            this.processSubMessage(artId);
        }
        for (ArtifactId artId : this.structureList) {
            this.processStructure(artId);
        }
        for (ArtifactId artId : this.elementList) {
            this.processElement(artId, ArtifactId.SENTINEL);
        }
        for (ArtifactId artId : this.pTypeList) {
            this.processPlatformType(artId);
        }
        for (ArtifactId artId : this.enumList) {
            this.processEnumeration(artId);
        }
        return this.diffReport;
    }

    private void processNode(ArtifactId nodeId) {
        List<ChangeItem> changeItems = this.changeMap.get(nodeId);
        InterfaceNode node = this.interfaceNodeApi.get(this.getBranchId(nodeId), nodeId);
        if (node.isValid()) {
            this.diffReport.addItem(node, changeItems);
            this.diffReport.getNodes().add(nodeId);
        }
    }

    private void processConnection(ArtifactId connectionId) {
        InterfaceConnection connection = this.interfaceConnectionApi.get(this.getBranchId(connectionId), connectionId);
        if (connection.isValid()) {
            this.diffReport.addItem(connection, this.getChangeList(connectionId));
            this.diffReport.getConnections().add(connectionId);
        }
    }

    private void processMessage(ArtifactId messageId) {
        InterfaceMessageToken message = this.interfaceMessageApi.getWithAllParentRelations(this.getBranchId(messageId), messageId);
        if (message.isValid()) {
            this.diffReport.addItem(message, this.getChangeList(messageId));
            this.addMessageParent(message);
            this.diffReport.getMessages().add(messageId);
        }
    }

    private void processSubMessage(ArtifactId submessageId) {
        InterfaceSubMessageToken subMessage = this.interfaceSubMessageApi.getWithAllParentRelations(this.getBranchId(submessageId), submessageId);
        if (subMessage.isValid()) {
            this.diffReport.addItem(subMessage, this.getChangeList(submessageId));
            this.addSubMessageParents(subMessage);
            this.diffReport.getSubMessages().add(submessageId);
        }
    }

    private void processStructure(ArtifactId structureId) {
        InterfaceStructureToken structure = this.interfaceStructureApi.getWithAllParentRelations(this.getBranchId(structureId), structureId);
        if (structure.isValid()) {
            this.diffReport.addItem(structure, this.getChangeList(structureId));
            this.addStructureParents(structure);
            this.diffReport.getStructures().add(structureId);
        }
    }

    private void processElement(ArtifactId elementId, ArtifactId typeId) {
        InterfaceStructureElementToken element = this.interfaceElementApi.get(this.getBranchId(elementId), elementId);
        this.pTypeList.add(ArtifactId.valueOf((Long)element.getPlatformTypeId()));
        this.processElement(elementId, typeId, element);
    }

    private void processElement(ArtifactId elementId, ArtifactId typeId, InterfaceStructureElementToken element) {
        if (element.isValid()) {
            this.diffReport.addItem(element, this.getChangeList(elementId));
            if (typeId.isValid()) {
                this.diffReport.addItem(element, this.getChangeList(typeId));
            }
            if (!this.diffReport.hasParents(elementId)) {
                InterfaceStructureElementToken elementWithParentRelations = this.interfaceElementApi.getWithAllParentRelations(this.branch1, elementId);
                this.addElementParents(elementWithParentRelations);
            }
            if (!this.diffReport.getElements().contains(elementId)) {
                this.diffReport.getElements().add(elementId);
            }
        }
    }

    private void processPlatformType(ArtifactId pTypeId) {
        PlatformTypeToken pType = this.interfacePlatformApi.get(this.getBranchId(pTypeId), pTypeId);
        if (pType.isValid()) {
            this.diffReport.addItem(pType, this.getChangeList(pTypeId));
            List<InterfaceStructureElementToken> elements = this.interfaceElementApi.getElementsByType(this.getBranchId(pTypeId), pTypeId);
            for (InterfaceStructureElementToken element : elements) {
                this.processElement(ArtifactId.valueOf((Long)element.getId()), pTypeId, element);
            }
        }
    }

    private void processEnumeration(ArtifactId enumId) {
        InterfaceEnumeration enumeration = this.interfaceEnumerationApi.get(this.getBranchId(enumId), enumId, Arrays.asList(CoreRelationTypes.InterfaceEnumeration_EnumerationSet, CoreRelationTypes.InterfacePlatformTypeEnumeration_Element, CoreRelationTypes.InterfaceElementPlatformType_Element));
        List enumSets = enumeration.getArtifactReadable().getRelatedList(CoreRelationTypes.InterfaceEnumeration_EnumerationSet).stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceEnumerationSet((ArtifactReadable)a)).collect(Collectors.toList());
        for (InterfaceEnumerationSet enumSet : enumSets) {
            ArtifactId enumSetId = ArtifactId.valueOf((Long)enumSet.getId());
            InterfaceEnumerationSet populatedSet = this.interfaceEnumerationSetApi.get(this.getBranchId(enumId), enumSetId);
            this.diffReport.addItem(populatedSet, this.getChangeList(enumId));
            this.diffReport.getEnumSets().add(enumSetId);
            this.addEnumSetParents(enumSet);
        }
    }

    private void addMessageParent(InterfaceMessageToken message) {
        ArtifactId messageId = ArtifactId.valueOf((Long)message.getId());
        if (!this.diffReport.hasParents(messageId)) {
            InterfaceConnection connection = this.interfaceConnectionApi.getRelatedFromMessage(message);
            ArtifactId connectionId = ArtifactId.valueOf((Long)connection.getId());
            this.diffReport.addParent(messageId, connectionId);
            this.diffReport.addItem(connection);
        }
    }

    private void addSubMessageParents(InterfaceSubMessageToken subMessage) {
        ArtifactId subMessageId = ArtifactId.valueOf((Long)subMessage.getId());
        if (!this.diffReport.hasParents(subMessageId)) {
            List<InterfaceMessageToken> messages = this.interfaceMessageApi.getAllRelatedFromSubMessage(subMessage);
            for (InterfaceMessageToken message : messages) {
                ArtifactId messageId = ArtifactId.valueOf((Long)message.getId());
                this.diffReport.addParent(subMessageId, messageId);
                this.diffReport.addItem(message);
                this.addMessageParent(message);
            }
        }
    }

    private void addStructureParents(InterfaceStructureToken structure) {
        ArtifactId structureId = ArtifactId.valueOf((Long)structure.getId());
        if (!this.diffReport.hasParents(structureId)) {
            List<InterfaceSubMessageToken> subMessages = this.interfaceSubMessageApi.getAllRelatedFromStructure(structure);
            for (InterfaceSubMessageToken subMessage : subMessages) {
                ArtifactId subMessageId = ArtifactId.valueOf((Long)subMessage.getId());
                this.diffReport.addParent(structureId, subMessageId);
                this.diffReport.addItem(subMessage);
                this.addSubMessageParents(subMessage);
            }
        }
    }

    private void addElementParents(InterfaceStructureElementToken element) {
        ArtifactId elementId = ArtifactId.valueOf((Long)element.getId());
        if (!this.diffReport.hasParents(elementId)) {
            List<InterfaceStructureToken> structures = this.interfaceStructureApi.getAllRelatedFromElement(element);
            for (InterfaceStructureToken structure : structures) {
                ArtifactId structureId = ArtifactId.valueOf((Long)structure.getId());
                this.diffReport.addParent(elementId, structureId);
                this.diffReport.addItem(structure);
                this.addStructureParents(structure);
            }
        }
    }

    private void addEnumSetParents(InterfaceEnumerationSet enumSet) {
        ArtifactId enumSetId = ArtifactId.valueOf((Long)enumSet.getId());
        if (!this.diffReport.hasParents(enumSetId)) {
            for (PlatformTypeToken pType : this.interfacePlatformApi.getAllFromEnumerationSet(enumSet)) {
                ArtifactId pTypeId = ArtifactId.valueOf((Long)pType.getId());
                this.diffReport.addParent(enumSetId, pTypeId);
                for (InterfaceStructureElementToken element : this.interfaceElementApi.getAllFromPlatformType(pType)) {
                    this.processElement(ArtifactId.valueOf((Long)element.getId()), ArtifactId.SENTINEL);
                }
            }
        }
    }

    private BranchId getBranchId(ArtifactId artId) {
        List<ChangeItem> changes = this.changeMap.get(artId);
        if (changes == null || changes.isEmpty()) {
            return this.branch1;
        }
        ChangeItem change = changes.stream().filter(c -> c.getChangeType().getId() == ChangeType.Artifact.getId()).findFirst().orElse(null);
        change = change == null ? (ChangeItem)changes.stream().filter(c -> c.getChangeType().getId() == ChangeType.Relation.getId()).findFirst().orElse(null) : change;
        return change != null && change.isDeleted() ? this.branch2 : this.branch1;
    }

    private List<ChangeItem> getChangeList(ArtifactId artId) {
        return this.changeMap.getOrDefault(artId, new LinkedList());
    }

    private void addChangeToMap(ChangeItem changeItem) {
        ArtifactId artId = changeItem.getArtId();
        long itemTypeId = changeItem.getItemTypeId().getId();
        if (itemTypeId == CoreArtifactTypes.InterfaceNode.getId() || itemTypeId == CoreRelationTypes.InterfaceConnectionPrimary_Node.getId() || itemTypeId == CoreRelationTypes.InterfaceConnectionSecondary_Node.getId()) {
            if (!this.nodeList.contains(artId)) {
                this.nodeList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceConnection.getId()) {
            if (!this.connectionList.contains(artId)) {
                this.connectionList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceMessage.getId()) {
            if (!this.messageList.contains(artId)) {
                this.messageList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceSubMessage.getId()) {
            if (!this.submessageList.contains(artId)) {
                this.submessageList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceStructure.getId() || itemTypeId == CoreRelationTypes.InterfaceStructureContent.getId()) {
            if (!this.structureList.contains(artId)) {
                this.structureList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceDataElementArray.getId() || itemTypeId == CoreArtifactTypes.InterfaceDataElement.getId() || itemTypeId == CoreRelationTypes.InterfaceElementPlatformType.getId()) {
            if (!this.elementList.contains(artId)) {
                this.elementList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfacePlatformType.getId()) {
            if (!this.pTypeList.contains(artId)) {
                this.pTypeList.add(artId);
            }
        } else if (itemTypeId == CoreArtifactTypes.InterfaceEnum.getId() && !this.enumList.contains(artId)) {
            this.enumList.add(artId);
        }
    }

    @Override
    public Map<ArtifactId, MimDifferenceItem> getDifferences(BranchId branch, BranchId compareBranch) {
        List artChanges;
        List changes;
        HashMap<ArtifactId, List> changeItems = new HashMap<ArtifactId, List>();
        HashMap<ArtifactId, MimDifferenceItem> diffs = new HashMap<ArtifactId, MimDifferenceItem>();
        if (branch.equals(compareBranch)) {
            List txs = ((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andBranch(new BranchId[]{branch})).getResults().getList();
            TransactionToken currentTx = (TransactionToken)txs.get(txs.size() - 1);
            TransactionToken compareToTx = (TransactionToken)txs.get(txs.size() - 2);
            changes = this.orcsApi.getTransactionFactory().compareTxs((TransactionId)compareToTx, (TransactionId)currentTx);
        } else {
            TransactionToken currentTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch)).getResults().getExactlyOne();
            TransactionToken compareTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(compareBranch)).getResults().getExactlyOne();
            changes = this.orcsApi.getBranchOps().compareBranch(currentTx, compareTx);
        }
        for (ChangeItem change : changes) {
            if (!change.getArtId().isValid()) continue;
            artChanges = changeItems.getOrDefault(change.getArtId(), new LinkedList());
            artChanges.add(change);
            changeItems.put(change.getArtId(), artChanges);
        }
        for (ArtifactId id : changeItems.keySet()) {
            artChanges = (List)changeItems.get(id);
            MimDifferenceItem item = new MimDifferenceItem(id);
            boolean added = true;
            boolean deleted = false;
            for (ChangeItem change : artChanges) {
                if (!change.getNetChange().getModType().equals(ModificationType.NEW) && !change.getNetChange().getModType().equals(ModificationType.INTRODUCED)) {
                    added = false;
                }
                if (change.getChangeType().equals((Object)ChangeType.Attribute)) {
                    String oldValue = change.getBaselineVersion().getValue();
                    String newValue = change.getCurrentVersion().getValue();
                    item.addAttributeChange(change.getItemTypeId().getId(), oldValue, newValue);
                    continue;
                }
                if (change.getChangeType().equals((Object)ChangeType.Artifact) && change.getCurrentVersion().getModType().equals(ModificationType.DELETED)) {
                    deleted = true;
                    continue;
                }
                if (!change.getChangeType().equals((Object)ChangeType.Relation)) continue;
                boolean relationAdded = change.getCurrentVersion().getModType().equals(ModificationType.NEW) || change.getCurrentVersion().getModType().equals(ModificationType.INTRODUCED);
                item.addRelationChange(change.getItemTypeId().getId(), change.getArtIdB(), relationAdded);
            }
            if (item.getDiffs().isEmpty()) {
                added = false;
            }
            item.setAdded(added);
            item.setDeleted(deleted);
            diffs.put(id, item);
        }
        return diffs;
    }
}

