/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.task.JaxAttribute;
import org.eclipse.osee.ats.api.task.JaxRelation;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class JaxAtsWorkItem
extends JaxAtsObject {
    protected List<String> assigneeUserIds = new LinkedList<String>();
    protected List<ArtifactId> assigneeAccountIds = new LinkedList<ArtifactId>();
    protected Date createdDate;
    protected String createdByUserId;
    protected String workDef;
    protected String title;
    protected String atsId;
    protected String currentState;
    protected StateType stateType;
    List<JaxAttribute> attributes = new ArrayList<JaxAttribute>();
    List<JaxRelation> relations;

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public void setCreatedByUserId(String createdByUserId) {
        this.createdByUserId = createdByUserId;
    }

    public String toString() {
        return "JaxAtsTask [title=" + this.getName() + ", createdDate=" + this.createdDate + ", createdById=" + this.createdByUserId + ", assigneeIds=" + this.assigneeUserIds + "]";
    }

    public List<String> getAssigneeUserIds() {
        return this.assigneeUserIds;
    }

    public void setAssigneeUserIds(List<String> assigneeUserIds) {
        Conditions.assertFalse((boolean)assigneeUserIds.contains(AtsCoreUsers.SYSTEM_USER.getUserId()), (String)"Can't assign task to System User", (Object[])new Object[0]);
        this.assigneeUserIds = assigneeUserIds;
    }

    public void addAssigneeUserIds(String idString) {
        Conditions.assertFalse((boolean)idString.equals(AtsCoreUsers.SYSTEM_USER.getUserId()), (String)"Can't assign task to System User", (Object[])new Object[0]);
        this.assigneeUserIds.add(idString);
    }

    public List<JaxAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<JaxAttribute> attributes) {
        this.attributes = attributes;
    }

    public void addAttributes(AttributeTypeToken attrType, List<Object> values) {
        Conditions.assertNotNullOrEmpty(values, (String)"Values can not be empty", (Object[])new Object[0]);
        JaxAttribute attr = new JaxAttribute();
        attr.setAttrType(attrType);
        attr.getValues().addAll(values);
        this.attributes.add(attr);
    }

    public JaxAttribute addAttribute(AttributeTypeToken attrType, Object value) {
        Conditions.assertNotNull((Object)value, (String)"Value can not be null", (Object[])new Object[0]);
        JaxAttribute attr = new JaxAttribute();
        attr.setAttrType(attrType);
        attr.getValues().add(value);
        this.attributes.add(attr);
        return attr;
    }

    public void addRelation(RelationTypeSide relationSide, long ... relatedIds) {
        JaxRelation relation = new JaxRelation();
        relation.setRelationTypeName(relationSide.getName());
        relation.setSideA(relationSide.getSide().isSideA());
        long[] lArray = relatedIds;
        int n = relatedIds.length;
        int n2 = 0;
        while (n2 < n) {
            long relatedId = lArray[n2];
            relation.getRelatedIds().add(relatedId);
            ++n2;
        }
        this.getRelations().add(relation);
    }

    public List<JaxRelation> getRelations() {
        if (this.relations == null) {
            this.relations = new LinkedList<JaxRelation>();
        }
        return this.relations;
    }

    public void setRelations(List<JaxRelation> relations) {
        this.relations = relations;
    }

    public List<ArtifactId> getAssigneeAccountIds() {
        return this.assigneeAccountIds;
    }

    public void setAssigneeAccountIds(List<ArtifactId> assigneeAccountIds) {
        this.assigneeAccountIds = assigneeAccountIds;
    }

    @JsonIgnore
    public ArtifactToken getToken() {
        return ArtifactToken.valueOf((ArtifactId)ArtifactId.valueOf((Long)this.getId()), (BranchToken)CoreBranches.COMMON);
    }

    public String getWorkDef() {
        return this.workDef;
    }

    public void setWorkDef(String workDef) {
        this.workDef = workDef;
    }

    public String getAtsId() {
        return this.atsId;
    }

    public void setAtsId(String atsId) {
        this.atsId = atsId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public StateType getStateType() {
        return this.stateType;
    }

    public void setStateType(StateType stateType) {
        this.stateType = stateType;
    }
}

