/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.cr.taskest;

import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstDefinition;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstUtil;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.TaskXViewer;
import org.eclipse.osee.ats.ide.world.WorldLabelProvider;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.XAbstractSignDateAndByButton;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class XTaskEstLabelProvider
extends WorldLabelProvider {
    private final AtsApi atsApi = AtsApiService.get();

    public XTaskEstLabelProvider(TaskXViewer xTaskViewer) {
        super(xTaskViewer);
    }

    @Override
    public Color getForeground(Object element, XViewerColumn xCol, int columnIndex) {
        if (element instanceof TaskEstDefinition) {
            return null;
        }
        return super.getForeground(element, xCol, columnIndex);
    }

    @Override
    public Color getBackground(Object element, XViewerColumn xCol, int columnIndex) {
        if (element instanceof TaskEstDefinition) {
            return null;
        }
        return super.getBackground(element, xCol, columnIndex);
    }

    public String getColumnText(Object element, int columnIndex) {
        XViewerColumn xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
        if (element instanceof TaskEstDefinition) {
            TaskEstDefinition ted = (TaskEstDefinition)element;
            if (xViewerColumn.getName().equals("Title")) {
                return ted.getName();
            }
            if (xViewerColumn.getName().equals("Select")) {
                return ted.isChecked() ? "Selected" : "";
            }
        } else if (element instanceof IAtsTask) {
            IAtsTask task = (IAtsTask)element;
            if (xViewerColumn.getName().equals("Select")) {
                if (task.getTags().contains(TaskEstUtil.TASK_EST_CANNED)) {
                    return "Canned";
                }
                if (task.getTags().contains(TaskEstUtil.TASK_EST_MANUAL)) {
                    return "Manual";
                }
                return "Other";
            }
            if (xViewerColumn.getName().equals("Attachments")) {
                int count = this.atsApi.getRelationResolver().getRelatedCount((IAtsWorkItem)task, CoreRelationTypes.SupportingInfo_SupportingInfo);
                if (count > 0) {
                    return String.valueOf(count);
                }
                return "";
            }
            if (xViewerColumn.getName().equals("Reviewed By")) {
                return XAbstractSignDateAndByButton.getText((Artifact)((Artifact)task.getStoreObject()), (AttributeTypeId)AtsAttributeTypes.ReviewedByDate, (AttributeTypeId)AtsAttributeTypes.ReviewedBy);
            }
            if (xViewerColumn.getName().equals("Related Workflow")) {
                if (task.isCancelled()) {
                    return "";
                }
                IAtsTeamWorkflow teamWf = TaskEstUtil.getWorkflow((IAtsTeamWorkflow)task.getParentTeamWorkflow(), (IAtsTask)task, (AtsApi)this.atsApi);
                if (teamWf != null) {
                    return teamWf.toStringWithId();
                }
                return "Select to Create Workflow";
            }
        }
        String str = super.getColumnText(element, columnIndex);
        return str;
    }

    @Override
    public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
        XViewerColumn xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
        if (element instanceof TaskEstDefinition) {
            TaskEstDefinition ted = (TaskEstDefinition)element;
            if (xViewerColumn.getName().equals("Select")) {
                if (ted.isChecked()) {
                    return ImageManager.getImage((KeyedImage)FrameworkImage.CHECKBOX_CHECK_TRUE);
                }
                return ImageManager.getImage((KeyedImage)FrameworkImage.CHECKBOX_CHECK_UNSET);
            }
        } else if (element instanceof IAtsTask) {
            IAtsTask task = (IAtsTask)element;
            if (xViewerColumn.getName().equals("Select")) {
                return ImageManager.getImage((OseeImage)AtsImage.TASK);
            }
            if (xViewerColumn.getName().equals("Reviewed By")) {
                if (this.atsApi.getAttributeResolver().getAttributeCount((IAtsWorkItem)task, (AttributeTypeToken)AtsAttributeTypes.ReviewedBy) > 0) {
                    return ImageManager.getImage((OseeImage)AtsImage.CHECK_BLUE);
                }
            } else if (xViewerColumn.getName().equals("Related Workflow")) {
                if (task.isCancelled()) {
                    return null;
                }
                IAtsTeamWorkflow teamWf = TaskEstUtil.getWorkflow((IAtsTeamWorkflow)task.getParentTeamWorkflow(), (IAtsTask)task, (AtsApi)this.atsApi);
                if (teamWf != null) {
                    return ImageManager.getImage((OseeImage)AtsImage.WORKFLOW);
                }
                return ImageManager.getImage((KeyedImage)FrameworkImage.ADD_GREEN);
            }
        }
        return null;
    }
}

