/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.defect;

import java.util.Date;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.review.PeerReviewDefectXViewerColumns;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectDispositionToImage;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectSeverityToImage;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectXViewer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class DefectLabelProvider
extends XViewerLabelProvider {
    public DefectLabelProvider(DefectXViewer xViewer) {
        super((XViewer)xViewer);
    }

    public Image getColumnImage(Object element, XViewerColumn dCol, int columnIndex) {
        ReviewDefectItem defectItem = (ReviewDefectItem)element;
        if (dCol.equals((Object)PeerReviewDefectXViewerColumns.Severity_Col)) {
            return DefectSeverityToImage.getImage(defectItem.getSeverity());
        }
        if (dCol.equals((Object)PeerReviewDefectXViewerColumns.Injection_Activity_Col)) {
            return ImageManager.getImage((KeyedImage)FrameworkImage.INFO_SM);
        }
        if (dCol.equals((Object)PeerReviewDefectXViewerColumns.Disposition_Col)) {
            return DefectDispositionToImage.getImage(defectItem.getDisposition());
        }
        if (dCol.equals((Object)PeerReviewDefectXViewerColumns.Closed_Col)) {
            return ImageManager.getImage((KeyedImage)(defectItem.isClosed() ? PluginUiImage.CHECKBOX_ENABLED : PluginUiImage.CHECKBOX_DISABLED));
        }
        if (dCol.equals((Object)PeerReviewDefectXViewerColumns.User_Col)) {
            try {
                User user = UserManager.getUserByUserId((String)defectItem.getUserId());
                return ArtifactImageManager.getImage((Artifact)user);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        } else if (dCol.equals((Object)PeerReviewDefectXViewerColumns.Closed_By_Col)) {
            try {
                if (Strings.isValid((String)defectItem.getClosedUserId())) {
                    User user = UserManager.getUserByUserId((String)defectItem.getClosedUserId());
                    return ArtifactImageManager.getImage((Artifact)user);
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return null;
    }

    public String getColumnText(Object element, XViewerColumn aCol, int columnIndex) {
        ReviewDefectItem defectItem = (ReviewDefectItem)element;
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.User_Col)) {
            String name;
            try {
                AtsUser atsUser = AtsApiService.get().getUserService().getUserByUserId(defectItem.getUserId());
                name = atsUser.getName();
            }
            catch (OseeCoreException ex) {
                name = String.format("Erroring getting user name: [%s]", ex.getLocalizedMessage());
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            return name;
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.Closed_By_Col)) {
            String name = "";
            if (Strings.isValid((String)defectItem.getClosedUserId())) {
                try {
                    AtsUser atsUser = AtsApiService.get().getUserService().getUserByUserId(defectItem.getClosedUserId());
                    name = atsUser.getName();
                }
                catch (OseeCoreException ex) {
                    name = String.format("Erroring getting user name: [%s]", ex.getLocalizedMessage());
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
            return name;
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.Closed_Col)) {
            return String.valueOf(defectItem.isClosed());
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.Created_Date_Col)) {
            return DateUtil.getMMDDYYHHMM((Date)defectItem.getDate());
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.Description_Col)) {
            return defectItem.getDescription();
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.Resolution_Col)) {
            return defectItem.getResolution();
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.DefectId_Col)) {
            return String.valueOf(defectItem.getId());
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.Location_Col)) {
            return defectItem.getLocation();
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.Severity_Col)) {
            return defectItem.getSeverity().equals((Object)ReviewDefectItem.Severity.None) ? "" : defectItem.getSeverity().name();
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.Disposition_Col)) {
            return defectItem.getDisposition().equals((Object)ReviewDefectItem.Disposition.None) ? "" : defectItem.getDisposition().name();
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.Injection_Activity_Col)) {
            return defectItem.getInjectionActivity() == ReviewDefectItem.InjectionActivity.None ? "" : defectItem.getInjectionActivity().name();
        }
        if (aCol.equals((Object)PeerReviewDefectXViewerColumns.Notes_Col)) {
            return defectItem.getNotes();
        }
        return "Unhandled Column";
    }

    public Object getBackingData(Object element, XViewerColumn xCol, int columnIndex) throws Exception {
        if (!(element instanceof ReviewDefectItem)) {
            return "";
        }
        ReviewDefectItem item = (ReviewDefectItem)element;
        if (xCol.getId().equals(PeerReviewDefectXViewerColumns.Created_Date_Col.getId())) {
            return item.getDate();
        }
        return super.getBackingData(element, xCol, columnIndex);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

