/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.ide.workflow.chgtype.ChangeTypeDialog;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericXWidget;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class XHyperlinkChangeTypeSelection
extends GenericXWidget {
    public static final String WIDGET_ID = XHyperlinkChangeTypeSelection.class.getSimpleName();
    protected Hyperlink labelHyperlink;
    protected Label labelWidget;
    protected Label valueLabel;
    protected Composite comp;
    protected boolean includeColon = true;
    protected ChangeTypes selected = ChangeTypes.None;
    protected final List<ChangeTypes> changeTypes = new ArrayList<ChangeTypes>();

    public XHyperlinkChangeTypeSelection() {
        this("");
    }

    public XHyperlinkChangeTypeSelection(String label) {
        super(label);
    }

    public XHyperlinkChangeTypeSelection(String label, ChangeTypes ... changeTypes) {
        super(label);
        ChangeTypes[] changeTypesArray = changeTypes;
        int n = changeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeTypes type = changeTypesArray[n2];
            this.changeTypes.add(type);
            ++n2;
        }
    }

    public String getCurrentValue() {
        if (this.selected == null || this.selected.equals((Object)ChangeTypes.None)) {
            return Widgets.NOT_SET;
        }
        return this.selected.name();
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        this.comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 1;
        this.comp.setLayout((Layout)layout);
        if (this.isFillHorizontally()) {
            this.comp.setLayoutData((Object)new GridData(768));
        } else {
            this.comp.setLayoutData((Object)new GridData());
        }
        if (this.toolkit != null) {
            this.toolkit.adapt(this.comp);
        }
        if (this.isEditable()) {
            if (this.toolkit == null) {
                this.labelHyperlink = new Hyperlink(this.comp, 0);
                this.labelHyperlink.setText(this.getLabel());
            } else {
                this.labelHyperlink = this.toolkit.createHyperlink(this.comp, String.valueOf(this.getLabel()) + (this.isIncludeColon() ? ":" : ""), 0);
            }
            this.labelHyperlink.setToolTipText(Strings.isValid((String)this.getToolTip()) ? this.getToolTip() : "Select to Modify");
            this.labelHyperlink.setLayoutData((Object)new GridData());
            if (this.getToolTip() != null) {
                this.labelHyperlink.setToolTipText(this.getToolTip());
            }
            this.labelHyperlink.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    ChangeTypeDialog dialog;
                    if (event.button == 1 && (dialog = new ChangeTypeDialog(null, XHyperlinkChangeTypeSelection.this.getChangeTypes())).open() == 0) {
                        XHyperlinkChangeTypeSelection.this.selected = (ChangeTypes)dialog.getSelected();
                        XHyperlinkChangeTypeSelection.this.handleSelected(XHyperlinkChangeTypeSelection.this.selected);
                    }
                }
            });
        } else {
            this.labelWidget = this.toolkit == null ? new Label(this.comp, 0) : this.toolkit.createLabel(this.comp, String.valueOf(this.getLabel()) + ":", 0);
            this.labelWidget.setLayoutData((Object)new GridData());
        }
        GridData gd = new GridData();
        if (this.isFillHorizontally()) {
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
        this.valueLabel = new Label(this.comp, 0);
        this.valueLabel.setText(String.valueOf(this.getLabel()) + ":");
        if (this.toolkit != null) {
            this.toolkit.adapt((Control)this.valueLabel, false, false);
        }
        this.valueLabel.setLayoutData((Object)gd);
        if (this.getToolTip() != null) {
            this.valueLabel.setToolTipText(this.getToolTip());
        }
        this.refresh();
    }

    protected List<ChangeTypes> getChangeTypes() {
        return this.changeTypes;
    }

    protected void handleSelected(ChangeTypes selected) {
        this.refresh();
        this.notifyXModifiedListeners();
    }

    public void refresh() {
        if (!Widgets.isAccessible((Widget)this.comp)) {
            return;
        }
        if (Widgets.isAccessible((Widget)this.valueLabel)) {
            if (this.getCurrentValue().equals(this.valueLabel.getText())) {
                return;
            }
            this.valueLabel.setText(this.getCurrentValue());
            this.valueLabel.update();
            this.valueLabel.getParent().update();
            this.valueLabel.getParent().getParent().layout();
        }
        this.validate();
    }

    public String toHTML(String labelFont) {
        return AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)this.getLabel(), (String)this.getCurrentValue());
    }

    public Control getControl() {
        if (this.labelWidget != null) {
            return this.labelWidget;
        }
        if (this.labelHyperlink != null) {
            return this.labelHyperlink;
        }
        return this.comp;
    }

    public boolean isIncludeColon() {
        return this.includeColon;
    }

    public void setIncludeColon(boolean includeColon) {
        this.includeColon = includeColon;
    }

    public void addLabelWidgetListener(MouseListener listener) {
        if (Widgets.isAccessible((Widget)this.labelHyperlink)) {
            this.labelHyperlink.addMouseListener(listener);
        }
    }

    public void addLabelMouseListener(MouseListener listener) {
        if (Widgets.isAccessible((Widget)this.labelHyperlink)) {
            this.labelHyperlink.addMouseListener(listener);
        }
    }

    public Label getLabelWidget() {
        return null;
    }

    public Hyperlink getLabelHyperlink() {
        return this.labelHyperlink;
    }

    public void setSelected(String name) {
        for (ChangeTypes type : this.changeTypes) {
            if (!name.equals(type.name())) continue;
            this.selected = type;
            break;
        }
        this.refresh();
    }

    public void setSelectable(Collection<ChangeTypes> changeTypes) {
        this.changeTypes.clear();
        this.changeTypes.addAll(changeTypes);
    }

    public IStatus isValid() {
        IStatus status = super.isValid();
        if (this.isRequiredEntry() && (this.selected == null || this.selected == ChangeTypes.None)) {
            status = new Status(4, "org.eclipse.osee.ats.ide", "Must Select Change Type");
        }
        return status;
    }

    public ChangeTypes getSelected() {
        return this.selected;
    }

    public void setSelected(ChangeTypes selected) {
        this.selected = selected;
        this.refresh();
    }

    public List<ChangeTypes> getSelectable() {
        return this.changeTypes;
    }

    public Object getData() {
        return this.selected;
    }
}

