/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class PurgeUser
extends AbstractBlam {
    public static final String FROM_USER = "From User";
    public static final String TO_USER = "To User";
    private static int numOfAuthoredTransactions = 0;
    private static int numOfASideRelations = 0;
    private static int numOfBSideRelations = 0;
    private static int numOfUpdatedAuthoredTransactions = 0;
    private static int numOfUpdatedASideRelations = 0;
    private static int numOfUpdatedBSideRelations = 0;
    private static boolean persist = false;
    private static final int defaultUpdateValue = -1;
    private static final String GET_AUTHORED_TRANSACTIONS = "SELECT count(1) from osee_tx_details where author=?";
    private static final String GET_RELATIONS_ASIDE = "SELECT count(1) from osee_relation_link where a_art_id=?";
    private static final String GET_RELATIONS_BSIDE = "SELECT count(1) from osee_relation_link where b_art_id=?";
    private static final String UPDATE_AUTHORED_TRANSACTIONS = "update osee_tx_details set author=? where author=?";
    private static final String UPDATE_RELATIONS_ASIDE = "update osee_relation_link set a_art_id=? where a_art_id=?";
    private static final String UPDATE_RELATIONS_BSIDE = "update osee_relation_link set b_art_id=? where b_art_id=?";
    private final JdbcClient jdbcClient = ConnectionHandler.getJdbcClient();

    public String getName() {
        return "Admin - Purge User";
    }

    public void runOperation(final VariableMap variableMap, IProgressMonitor monitor) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    persist = variableMap.getBoolean("Persist");
                    final User fromUser = variableMap.getUser(PurgeUser.FROM_USER);
                    if (fromUser == null) {
                        AWorkbench.popup((String)"ERROR", (String)"Please select From User");
                        return;
                    }
                    final User toUser = variableMap.getUser(PurgeUser.TO_USER);
                    if (toUser == null) {
                        AWorkbench.popup((String)"ERROR", (String)"Please select To User");
                        return;
                    }
                    try {
                        PurgeUser.this.jdbcClient.runTransaction(new JdbcTransaction(){

                            public void handleTxWork(JdbcConnection connection) {
                                PurgeUser.this.findAndUpdateAuthoredTransactions(connection, fromUser, toUser);
                                PurgeUser.this.findAndUpdateRelations(connection, fromUser, toUser);
                            }
                        });
                        PurgeUser.this.confirmDeletionOfArtifact(fromUser);
                        PurgeUser.this.displayReport(toUser, fromUser);
                    }
                    catch (Exception ex) {
                        PurgeUser.this.log(ex);
                    }
                }
                finally {
                    numOfAuthoredTransactions = 0;
                    numOfASideRelations = 0;
                    numOfBSideRelations = 0;
                    numOfUpdatedAuthoredTransactions = 0;
                    numOfUpdatedASideRelations = 0;
                    numOfUpdatedBSideRelations = 0;
                }
            }
        });
    }

    private void confirmDeletionOfArtifact(User fromUser) {
        if (persist && MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Persist Confirmation", (String)("Do you wish to delete the User artifact: " + fromUser.getName() + "?"))) {
            this.deleteArtifact(fromUser);
        }
    }

    private void findAndUpdateAuthoredTransactions(JdbcConnection connection, User fromUser, User toUser) {
        numOfAuthoredTransactions = (Integer)this.jdbcClient.fetch((Object)-1, GET_AUTHORED_TRANSACTIONS, new Object[]{fromUser});
        if (persist) {
            numOfUpdatedAuthoredTransactions = this.jdbcClient.runPreparedUpdate(connection, UPDATE_AUTHORED_TRANSACTIONS, new Object[]{toUser, fromUser});
        }
    }

    private void findAndUpdateRelations(JdbcConnection connection, User fromUser, User toUser) {
        this.updateRelationA(connection, fromUser, toUser);
        this.updateRelationB(connection, fromUser, toUser);
    }

    private void updateRelationA(JdbcConnection connection, User fromUser, User toUser) {
        numOfASideRelations = (Integer)this.jdbcClient.fetch((Object)-1, GET_RELATIONS_ASIDE, new Object[]{fromUser});
        if (persist) {
            numOfUpdatedASideRelations = this.jdbcClient.runPreparedUpdate(connection, UPDATE_RELATIONS_ASIDE, new Object[]{toUser, fromUser});
        }
    }

    private void updateRelationB(JdbcConnection connection, User fromUser, User toUser) {
        numOfBSideRelations = (Integer)this.jdbcClient.fetch((Object)-1, GET_RELATIONS_BSIDE, new Object[]{fromUser});
        if (persist) {
            numOfUpdatedBSideRelations = this.jdbcClient.runPreparedUpdate(connection, UPDATE_RELATIONS_BSIDE, new Object[]{toUser, fromUser});
        }
    }

    private void deleteArtifact(User fromUser) {
        Artifact art = ArtifactQuery.getArtifactFromToken((ArtifactId)fromUser);
        art.purgeFromBranch();
    }

    private void displayReport(User toUser, User fromUser) {
        XResultData rd = new XResultData();
        rd.logf("%s\n\n", new Object[]{this.getName()});
        if (persist) {
            rd.logf("Persisted Changes to DB and Purged User Artifact\n\n", new Object[]{this.getName()});
        } else {
            rd.logf("REPORT ONLY; No changes made\n\n", new Object[]{this.getName()});
        }
        try {
            String[] columnHeaders = new String[]{"FromUser", "FromUser ArtId", "ToUser", "ToUser ArtId", "Authored Transaction Hits", "Relation ASide Hits", "Relation BSide Hits", "Authored Transaction Updated", "Relation ASide Update", "Relation BSide Updated"};
            rd.addRaw(AHTML.beginMultiColumnTable((int)100, (int)1));
            rd.addRaw(AHTML.addHeaderRowMultiColumnTable((String[])columnHeaders));
            rd.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{fromUser.getName(), fromUser.getIdString(), toUser.getName(), toUser.getIdString(), Integer.toString(numOfAuthoredTransactions), Integer.toString(numOfASideRelations), Integer.toString(numOfBSideRelations), Integer.toString(numOfUpdatedAuthoredTransactions), Integer.toString(numOfUpdatedASideRelations), Integer.toString(numOfUpdatedBSideRelations)}));
            rd.addRaw(AHTML.endMultiColumnTable());
        }
        finally {
            XResultDataUI.report((XResultData)rd, (String)this.getName());
        }
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        XWidgetBuilder wb = new XWidgetBuilder();
        wb.andWidget(FROM_USER, "XMembersComboAll").endWidget();
        wb.andWidget(TO_USER, "XMembersComboAll").endWidget();
        wb.andXCheckbox("Persist").endWidget();
        return wb.getItems();
    }

    public String getDescriptionUsage() {
        return "Purge the specified User.  Choose user to purge and user to re-assign existing transactions and relations.  Select Persist to make changes and purge User Artifact.";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.USER_MANAGEMENT_ADMIN, XNavItemCat.OSEE_ADMIN);
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)FrameworkImage.X_RED);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.X_RED);
    }
}

