/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.section;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.WfeWorkflowSection;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WfeUndefinedStateSection
extends SectionPart {
    private final WorkflowEditor editor;
    private boolean sectionCreated = false;
    private final String stateName;

    public WfeUndefinedStateSection(String stateName, WorkflowEditor editor, Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style | 2 | 0x100);
        this.stateName = stateName;
        this.editor = editor;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        Section section = this.getSection();
        try {
            section.setText("Un-Defined State - " + WfeWorkflowSection.getCurrentStateTitle(this.editor.getWorkItem(), this.stateName, false, false));
        }
        catch (OseeCoreException ex) {
            section.setText(String.valueOf(this.stateName) + " - Exception:" + ex.getLocalizedMessage());
        }
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                WfeUndefinedStateSection.this.createSection();
            }
        });
    }

    public static boolean hasUndefinedStates(AbstractWorkflowArtifact awa) {
        return !WfeUndefinedStateSection.getUndefinedStateNames(awa).isEmpty();
    }

    public List<String> getUndefinedStateNames() {
        return WfeUndefinedStateSection.getUndefinedStateNames(this.editor.getWorkItem());
    }

    public static List<String> getUndefinedStateNames(AbstractWorkflowArtifact awa) {
        Collection stateNamesDefined = AtsApiService.get().getWorkDefinitionService().getStateNames(awa.getWorkDefinition());
        ArrayList<String> stateNamesUndefined = new ArrayList<String>();
        for (String pageName : awa.getAttributesToStringList((AttributeTypeId)AtsAttributeTypes.State)) {
            String justPage = pageName.replaceFirst(";.*$", "");
            if (stateNamesDefined.contains(justPage)) continue;
            stateNamesUndefined.add(justPage);
        }
        return stateNamesUndefined;
    }

    private synchronized void createSection() {
        if (this.sectionCreated) {
            return;
        }
        AbstractWorkflowArtifact awa = this.editor.getWorkItem();
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Composite composite = toolkit.createComposite((Composite)this.getSection(), 64);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.createLabel(composite, "This state is no-longer defined by the current Work Definition.", 0);
        String infoStr = "";
        try {
            infoStr = String.format("Name: [%s] Assignees: [%s]", this.stateName, awa.getStateMgr().getAssigneesStr(this.stateName, 100));
        }
        catch (OseeCoreException ex) {
            infoStr = "Exception processing state data (see log for details) " + ex.getLocalizedMessage();
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        toolkit.createLabel(composite, infoStr, 0);
        this.getSection().setClient((Control)composite);
        toolkit.paintBordersFor(composite);
        this.sectionCreated = true;
    }
}

