/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XReviewedWidget;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XAbstractSignDateAndByButton;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ReviewedByColumn
extends XViewerAtsColumn
implements IXViewerValueColumn,
IAltLeftClickProvider,
IMultiColumnEditProvider {
    public static ReviewedByColumn instance = new ReviewedByColumn();
    private final AtsApi atsApi = AtsApiService.get();

    public static ReviewedByColumn getInstance() {
        return instance;
    }

    private ReviewedByColumn() {
        super("ats.taskest.reviewed", "Reviewed By", 20, XViewerAlign.Left, true, SortDataType.String, true, "");
    }

    public ReviewedByColumn copy() {
        ReviewedByColumn newXCol = new ReviewedByColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block6: {
            Artifact useArt;
            block9: {
                block8: {
                    block7: {
                        if (!(treeItem.getData() instanceof Artifact)) break block6;
                        useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                        XResultData rd = XReviewedWidget.checkReviewedBy((ArtifactToken)useArt);
                        if (!rd.isErrors()) break block7;
                        return false;
                    }
                    if (!useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) break block8;
                    if (AtsApiService.get().getWorkItemService().getTeams((Object)useArt).size() == 1) {
                        useArt = AtsApiService.get().getQueryServiceIde().getArtifact(AtsApiService.get().getWorkItemService().getFirstTeam((Object)useArt));
                        break block8;
                    }
                    return false;
                }
                if (useArt instanceof IAtsWorkItem) break block9;
                return false;
            }
            try {
                IAtsWorkItem workItem = (IAtsWorkItem)useArt;
                XReviewedWidget widget = new XReviewedWidget();
                widget.setArtifact((Artifact)workItem.getStoreObject());
                widget.handleSelection();
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                xViewer.update((Object)useArt, null);
                return true;
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean promptChange(IAtsWorkItem workItem, AtsApi atsApi) {
        return ReviewedByColumn.promptChange(Collections.singleton(workItem), atsApi);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean promptChange(final Collection<IAtsWorkItem> workItems, AtsApi atsApi) {
        try {
            IAtsWorkItem workItem;
            XResultData rd;
            Iterator<IAtsWorkItem> iterator = workItems.iterator();
            do {
                if (iterator.hasNext()) continue;
                final int res = MessageDialog.open((int)3, (Shell)Displays.getActiveShell(), (String)"Reviewed By", (String)"Has been Reviewed", (int)0, (String[])new String[]{"Ok", "Cancel", "Clear"});
                Job signJob = new Job("Set Reviewed By"){

                    protected IStatus run(IProgressMonitor monitor) {
                        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
                        for (IAtsWorkItem workItem : workItems) {
                            artifacts.add((Artifact)workItem.getStoreObject());
                        }
                        if (res == 2) {
                            XAbstractSignDateAndByButton.setSigned(artifacts, (AttributeTypeId)AtsAttributeTypes.ReviewedByDate, (AttributeTypeId)AtsAttributeTypes.ReviewedBy, (String)"Reviewed By", (boolean)false);
                        } else if (res == 0) {
                            XAbstractSignDateAndByButton.setSigned(artifacts, (AttributeTypeId)AtsAttributeTypes.ReviewedByDate, (AttributeTypeId)AtsAttributeTypes.ReviewedBy, (String)"Reviewed By", (boolean)true);
                        }
                        return Status.OK_STATUS;
                    }
                };
                Operations.scheduleJob((Job)signJob, (boolean)false, (int)20, null);
                return true;
            } while (!(rd = XReviewedWidget.checkReviewedBy((workItem = iterator.next()).getArtifactToken())).isErrors());
            return false;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return true;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        block5: {
            try {
                if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                    HashSet<String> strs = new HashSet<String>();
                    for (IAtsTeamWorkflow teamWf : AtsApiService.get().getWorkItemService().getTeams(element)) {
                        AttributeTypeToken pointsAttrType = this.atsApi.getAgileService().getPointsAttrType((IAtsWorkItem)teamWf);
                        String ptsStr = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, pointsAttrType, (Object)"");
                        if (!Strings.isValid((String)ptsStr)) continue;
                        strs.add(ptsStr);
                    }
                    return org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)"; ", strs);
                }
                if (element instanceof IAtsWorkItem) break block5;
                return "";
            }
            catch (OseeCoreException ex) {
                return LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
        }
        IAtsWorkItem workItem = (IAtsWorkItem)element;
        return XAbstractSignDateAndByButton.getText((Artifact)((Artifact)workItem.getStoreObject()), (AttributeTypeId)AtsAttributeTypes.ReviewedByDate, (AttributeTypeId)AtsAttributeTypes.ReviewedBy);
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
            for (TreeItem item : treeItems) {
                Artifact art;
                if (!(item.getData() instanceof IAtsWorkItem) || !((art = AtsApiService.get().getQueryServiceIde().getArtifact(item)) instanceof IAtsWorkItem)) continue;
                workItems.add((IAtsWorkItem)art);
            }
            ReviewedByColumn.promptChange(workItems, this.atsApi);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

