/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.column.AbstractNumericTotalColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class RemainingPointsTotalColumn
extends AbstractNumericTotalColumn {
    private static final String CALCULATION_STR = "Points - (Points * (Percent Complete from Workflow Rollup (Team Wf, Tasks and Reviews) / 100))";
    private static RemainingPointsTotalColumn instance = new RemainingPointsTotalColumn();

    public static RemainingPointsTotalColumn getInstance() {
        return instance;
    }

    private RemainingPointsTotalColumn() {
        super("ats.column.remainingPointsTotal", "Remaining Points - Total", "Points that remain to complete the changes based on percent complete from workflow rollup.", CALCULATION_STR, (AttributeTypeToken)AtsAttributeTypes.Points);
    }

    public RemainingPointsTotalColumn copy() {
        RemainingPointsTotalColumn newXCol = new RemainingPointsTotalColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    protected int getPercentComplete(IAtsWorkItem workItem) {
        return AtsApiService.get().getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)workItem);
    }
}

